% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pimp.import.R
\name{pimp.import}
\alias{pimp.import}
\title{Predictor Importance - Variables and Interactions}
\usage{
pimp.import(fit, data, testdata, BSpred, pred, Xs, mtype)
}
\arguments{
\item{fit}{Fit information including outcome/model type, input data, logic tree, etc.}

\item{data}{In-bag sample (i.e., training data).}

\item{testdata}{Out-of-bag sample (i.e., test data).}

\item{BSpred}{Number of Xs in the interactions (includes not-ed variables).}

\item{pred}{Matrix of predicted values.}

\item{Xs}{Matrix or data frame of zeros and ones for all predictor variables.}

\item{mtype}{Model type: \code{"classification"}, \code{"linear"}, or \code{"survival regression"}.}
}
\value{
A list with:
\describe{
\item{single.vimp}{Vector of predictor importance estimates. One estimate per predictor used in the tree of that sample.}
\item{pimp.vimp}{Vector of interaction importance estimates. One estimate per interaction detected in that sample.}
\item{Ipimat}{Matrix updated for each sample. Contains all predictors (and their NOT-ed versions if used) for each interaction.}
\item{vec.Xvars}{Vector of predictors used in the tree of that sample.}
\item{Xids}{Vector of predictor IDs used in the tree of that sample.}
}
}
\description{
Measures the predictor importance for each predictor and interaction importance for each iteration.
}
\details{
This function is called to calculate importance measures for each bootstrapped sample.
Importance measures are calculated as differences between the original out-of-bag sample
and a permuted out-of-bag sample.
Model fit for both samples is evaluated using:
\itemize{
\item Concordance for classification,
\item Mean squared error for linear regression,
\item Harrell's C-index for survival regression.
}
}
\references{
Wolf BJ, Hill EG, Slate EH. Logic Forest: an ensemble classifier for discovering logical combinations of binary markers. \emph{Bioinformatics}. 2010;26(17):2183-2189. \doi{10.1093/bioinformatics/btq354}
}
\seealso{
\code{\link{logforest}}
}
\author{
Bethany J. Wolf \email{wolfb@musc.edu} \cr
J. Madison Hyer \email{madison.hyer@osumc.edu}
}
\keyword{internal}
