% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Module_composition.R
\name{Module_composition}
\alias{Module_composition}
\title{Pie chart for network module composition}
\usage{
Module_composition(
  network_obj,
  No.module,
  taxlevel = "Phylum",
  mode = "all",
  top_n = NULL,
  palette = "Set1",
  select_tax = NULL,
  rmprefix = NULL
)
}
\arguments{
\item{network_obj}{Network analysis results generated from \code{\link{network_analysis}}}

\item{No.module}{Numeric or numeric vector of No.module}

\item{taxlevel}{Taxonomy levels used for visualization.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").Default:"Phylum".}

\item{mode}{The mode for selecting which taxa to plot: "all" for all taxa, "most" for the top N taxa, and "select" for specific taxa selection}

\item{top_n}{The number of top taxa to plot when mode is set to "most"}

\item{palette}{Character. Palette for visualization,default:"Set1".See optional palette in same as 'RColorBrewer'. And "Plan1" to "Plan10" were also optional,see in \code{\link{color_scheme}}}

\item{select_tax}{A vector of taxa to be selected for plotting when mode is "select".}

\item{rmprefix}{A string prefix to be removed from the taxonomic annotation}
}
\value{
The function returns a list containing pie chart of specific module,corresponding source data and color assignments
}
\description{
This function analyzes the composition of modules within a network object,
providing a visual and data summary based on taxonomic levels.
}
\examples{
\donttest{
 #Data loading
 data("Two_group")

 # Network analysis
 network_Two_group <- network_analysis(
    taxobj = Two_group,
    taxlevel = "Genus",
    reads = TRUE,
    n = 8,
    threshold = 0.7
  )

  # Show all taxa
  module_results <- Module_composition(
    network_obj = network_Two_group,
    No.module = c(2, 5),
    taxlevel = "Phylum"
  )
  print(module_results$Module5$Pie)
  print(module_results$Module2$Pie)  # View pie chart
  head(module_results$Module2$source_data_Module2)  # View source data for pie chart
  print(module_results$aes_color)  # Check aesthetic color

  # Show taxa with top five frequency
  module_results <- Module_composition(
    network_obj = network_Two_group,
    No.module = c(2, 5),
    taxlevel = "Phylum",
    mode = "most",
    top_n = 5
  )
  print(module_results$Module2$Pie_plot_Module2)

  # Show specific taxa
  community <- community_plot(
    taxobj = Two_group,
    taxlevel = "Phylum",
    n = 5,
    palette = "Paired"
  )  # Get top 5 dominant phyla
  top5_phyla <- names(community$filled_color)

  module_results <- Module_composition(
    network_obj = network_Two_group,
    No.module = c(2, 5),
    taxlevel = "Phylum",
    mode = "select",
    palette = community$filled_color,
    select_tax = top5_phyla
  )
  print(module_results$Module2$Pie_plot_Module2)

  # Specific taxa with no prefix 'p__'
  module_results <- Module_composition(
    network_obj = network_Two_group,
    No.module = 2,
    taxlevel = "Phylum",
    mode = "select",
    select_tax = c("Proteobacteria", "Actinobacteria")
  )
  print(module_results$Module2$Pie_plot_Module2)

  # Remove 'p__' prefix
  module_results <- Module_composition(
    network_obj = network_Two_group,
    No.module = 2,
    taxlevel = "Phylum",
    mode = "most",
    top_n = 5,
    palette = "Set2",
    rmprefix = "p__"
  )
  print(module_results$Module2$Pie_plot_Module2)
  }
}
