% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_bar.R
\name{differential_bar}
\alias{differential_bar}
\title{Generate Differential Bar Plot and Error bar Plot}
\usage{
differential_bar(
  taxobj,
  taxlevel,
  comparison = NULL,
  rel_threshold = 0.005,
  anno_row = "taxonomy",
  aes_col = NULL,
  limit_num = NULL
)
}
\arguments{
\item{taxobj}{Configured tax summary objects.See in \code{\link{object_config}}.}

\item{taxlevel}{Taxonomy levels used for visualization. Must be one of
c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").}

\item{comparison}{A vector of conditions to compare. Default: NULL, all unique conditions are compared (only for Two groups).}

\item{rel_threshold}{Threshold filtering taxa for differential analysis. Default:0.005}

\item{anno_row}{Default: 'taxonomy'. Rownames for visualization. Options are 'taxonomy' for showing taxonomic information and 'ID' for showing taxonomic ID.}

\item{aes_col}{A named vector of colors to be used in the plots.}

\item{limit_num}{Numeric. The maximum number of significant results to display. Default: NULL, showing all differential taxa.}
}
\value{
A list containing the bar plot, source data for the bar plot, difference plot, and source data for the difference plot.
}
\description{
Generate Differential Bar Plot and Error bar Plot
}
\note{
The differential analysis is performed using two-sided Welch's t-test.
The p-values are adjusted using the 'BH' (i.e., FDR) method.
}
\examples{
{
  # Data preparation
  data("Two_group")

  # Simple mode
  diff_results <- differential_bar(
    taxobj = Two_group,
    taxlevel = "Genus"
  )
  print(diff_results$Barplot)  # Print Barplot
  head(diff_results$Barplot_sourcedata)  # Show source data of barplot
  print(diff_results$Differenceplot)  # Print Differential errorbar plot
  head(diff_results$Differenceplot_sourcedata)  # Show source data of Differential errorbar plot

  require(patchwork)
  diff_results$Barplot|diff_results$Differenceplot
  # Displaying ID
  diff_results <- differential_bar(
    taxobj = Two_group,
    taxlevel = "Base",
    anno_row = "ID"
  )
  print(diff_results$Barplot)

  # Threshold adjustment
  diff_results <- differential_bar(
    taxobj = Two_group,
    taxlevel = "Base",
    rel_threshold = 0.001
  )
  print(diff_results$Barplot)

  # Limit the displaying number
  diff_results <- differential_bar(
    taxobj = Two_group,
    taxlevel = "Base",
    rel_threshold = 0.001,
    limit_num = 10
  )
  print(diff_results$Barplot)

  # For object with more than two groups
  # Data preparation
  data("Three_group")

  # Specific comparison
  Three_group_col <- Three_group$configuration$treat_col
  diff_results <- differential_bar(
    taxobj = Three_group,
    taxlevel = "Genus",
    comparison = c("BF", "CF"),
    aes_col = Three_group_col
  )
  print(diff_results$Barplot)
}
}
