% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimMABOUST.R
\name{SimMABOUST}
\alias{SimMABOUST}
\title{Simulate the MABOUST Trial design.}
\usage{
SimMABOUST(
  nSims,
  NLOOK,
  nTreat,
  nCat,
  UT,
  DeltaVEC,
  gamma,
  PSPIKE,
  ADJ,
  B,
  PROBS,
  Beta,
  XPROB
)
}
\arguments{
\item{nSims}{Number of trial replications to complete.}

\item{NLOOK}{Vector containing how many patients should be evaluated before each interim decision.}

\item{nTreat}{Number of treatments in consideration, i.e. K.}

\item{nCat}{Number of ordinal outcome categories, i.e. J.}

\item{UT}{Vector of numerical utility scores to give outcomes 1,...,J.}

\item{DeltaVEC}{Vector of \eqn{\bf{\Delta}} values to test.}

\item{gamma}{Length 3 vector of cutoff parameters.}

\item{PSPIKE}{Prior probability of a pairwise null effect.}

\item{ADJ}{Binary indicator of whether covariate adjustment is used.}

\item{B}{Number of MCMC iterations to perform.}

\item{PROBS}{K-list of J-vectors containing ordinal outcome probabilities.}

\item{Beta}{Covariate Effect Vector on Outcome.}

\item{XPROB}{List of matrices containing discrete values various covariates can take, along with their probabilities.}
}
\value{
The set of active treatments to continue, an optimal treatment, or a set of equally optimal treatments. Also reports posterior mean utilities and ordinal outcome probabilities as well as pairwise comparisons of utility similarity, when appropriate.
}
\description{
Simulates trial replicates of the MABOUST trial and reports Operating Characteristics (OCs).
}
\examples{
##Clinical Parameters
nCat = 6
nTreat = 3
UT = c(0,10,20,80,90,100)  ###Utilities
DeltaVEC  = c(5,10)   ###Vector of deltas to try
NLOOK = c(20,50)  ###Interim Looks
###Which treatments are active?
ACTIVE = c(1,0,1) ###Treatments 1, 3 are active
FUTILITY = 1 ###Futility look is allowed.
###Design parameters
gamma= c(.5, .05, .05)
PSPIKE = .9
set.seed(1)
##Generate Random Data
n=300
Y=sample(1:nCat,n,replace=TRUE)
T1 = sample(1:nTreat,n,replace=TRUE)
XPROB = as.list(rep(NA,3))
XPROB[[1]]=rbind(0:10,round(dpois(0:10,2),2)) ###CCI
XPROB[[2]]=rbind(c(-1,0,1),c(.5,.4,.1)) ###O2 Status
XPROB[[3]]=rbind(c(-2,-1,0,1),c(.27,.38,.18,.17))
Beta =
###Number of iterations
B=100
##Get Simulation Parameters
 #' ##Get Simulation Parameters
 PROBS = as.list(rep(NA,3))
 PROBS[[1]]=c(.33,.11,.42,.02,.11,.01)
 PROBS[[2]]=c(.24,.11,.48,.05,.11,.01)
 PROBS[[3]]=c(.14, .20, .48, .03, .12, .03)
 Beta=c(-.13, -.07, -.10)
 nSims=1 ##Number of sims to run
 ADJ=1
 SimMABOUST(nSims,NLOOK, nTreat,nCat, UT, DeltaVEC,gamma,PSPIKE,ADJ, B, PROBS, Beta, XPROB)
}
\references{
Chapple, A.G., Bennani, Y., Clement, M. (2020). "MABOUST: A Multi-Armed Bayesian Ordinal Outcome Utility-Based Sequential Trial". Submitted.
}
