% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizing_MAGMA_functions.R
\name{Balance_MAGMA}
\alias{Balance_MAGMA}
\title{Balance_MAGMA}
\usage{
Balance_MAGMA(
  Data,
  group,
  covariates,
  step = "step",
  verbose = TRUE,
  covariates_ordinal = NULL,
  covariates_nominal = NULL
)
}
\arguments{
\item{Data}{A data frame containing at least the \emph{grouping} variable, the
\emph{step} variable from the main MAGMA-function (or other matching algorithms),
and all \emph{covariates} of interest.}

\item{group}{A character specifying the name of
your grouping variable in data. Note that MAGMA can only match your data for
a maximum of four groups. For matching over two grouping variables (e.g., 2x2
design) is possible by specifying group as a character vector with a length
of two. In this case, each of the two grouping variables can only have two
levels.}

\item{covariates}{A character vector listing the names of all binary and
metric covariates of interest.}

\item{step}{A character specifying the step variable of the matching. Per
default, it is set to \emph{step}, which corresponds the resulting
name of the main MAGMA function.}

\item{verbose}{TRUE or FALSE indicating whether matching information should
be printed to the console.}

\item{covariates_ordinal}{A character vector listing the names of all ordinal
covariates of interest.}

\item{covariates_nominal}{A character vector listing the names of all nominal
covariates of interest.}
}
\value{
A list of length four containing all balance criteria and all
pairwise effects with respect to group sample size.
}
\description{
This function computes all four balance criteria of 'MAGMA.R', namely
\emph{Pillai's Trace}, \emph{d-ratio}, \emph{mean g}, and \emph{adjusted d-ratio}. The
estimation considers the scale level of the variables. Balance
estimation is performed across various sample sizes. See Details for more
information.
}
\details{
This function computes all four balance criteria of 'MAGMA.R', namely
Pillai's Trace, d-ratio, mean g, and adjusted d-ratio. This is an iterative
process including more cases with each iteration according to the step
variable. Thus, starting with cases having a small within-match distance,
larger distances are included with increasing iterations. As a minimum the
function specifies n >= 20 per group. This does not imply that balance
criteria with such a small sample size can be estimated consistently. For
Pillai's Trace a higher minimum sample size can be possible. It depends on
the number of covariates to ensure a positive model identification.
Missing data for Pillai's Trace are excluded listwise, while for the other
balance criteria pairwise exclusion is applied.
}
\examples{

# Defining the names of the metric and binary covariates
covariates_vector <- c("GPA_school", "IQ_score", "Motivation", "parents_academic", "gender")


# Estimating balance of a two-group matching using the data set
# 'MAGMA_sim_data'.
# Matching variable 'gifted_support' (received giftedness support yes or no)
# Using subsample only for faster execution.
Balance_gifted <- Balance_MAGMA(Data = MAGMA_sim_data[MAGMA_sim_data$step_gifted < 200, ],
                                group = "gifted_support",
                                covariates = covariates_vector,
                                step = "step_gifted")
str(Balance_gifted)

\donttest{
# 2x2 matching using the data set 'MAGMA_sim_data'
# Matching variables are 'gifted_support' (received giftedness support yes
# or no) and 'enrichment' (participated in enrichment or not)
# 'MAGMA_sim_data_gift_enrich' contains the result of the matching
# 2x2 matching is equivalent to four-group matching
MAGMA_sim_data_gift_enrich <- MAGMA(Data = MAGMA_sim_data,
                                   group = c("gifted_support", "enrichment"),
                                   dist = "ps_2x2",
                                   cores = 2)


# Estimating balance. Covariates same as above
Balance_2x2 <- Balance_MAGMA(Data = MAGMA_sim_data_gift_enrich,
                             group = c("gifted_support", "enrichment"),
                             covariates = covariates_vector,
                             step = "step") # step created during matching
str(Balance_2x2)

}

}
\references{
{Pastore, M., Loro, P.A.D., Mingione, M., Calcagni, A. (2022). \emph{overlapping: Estimation of Overlapping in Empirical Distributions}. R package version
2.1, (\url{https://CRAN.R-project.org/package=overlapping}).

Revelle, W. (2023). \emph{psych: Procedures for Psychological, Psychometric, and Personality Research}. Northwestern University, Evanston, Illinois. R package version 2.3.6, (\url{https://CRAN.R-project.org/package=psych}).

Viechtbauer, W. (2010). Conducting meta-analyses in R with the metafor package. Journal of Statistical Software, 36(3), 1-48. (\doi{10.18637/jss.v036.i03})

Fisher, Z., Tipton, E., Zhipeng, H. (2023). \emph{robumeta: Robust Variance Meta-Regression}. R package version 2.1,
(\url{https://CRAN.R-project.org/package=robumeta}).}
}
\author{
Julian Urban
}
