% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-MissingData.R
\name{plot_missing_data}
\alias{plot_missing_data}
\title{Plot Missing Group Combinations}
\usage{
plot_missing_data(
  data,
  x,
  y,
  stratify_by = NULL,
  for_each = NULL,
  facet_labeller = NULL,
  title = "Missing data",
  subtitle = NULL,
  x_lab = NULL,
  y_lab = NULL
)
}
\arguments{
\item{data}{Data frame.}

\item{x}{Variable in \code{data} whose values define the x-axis.}

\item{y}{Variable in \code{data} whose values define the y-axis.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, missing data is examined separately for each leves of \code{stratify_by}, and each level gets its own panel.}

\item{for_each}{(Optional) Additional stratification variable. If supplied,
separate plot windows are created per level of \code{for_each}.}

\item{facet_labeller}{A \code{labeller} function (e.g. \code{\link[ggplot2]{labeller}}),
or a named list where names match facet variables and values are named
vectors/lists mapping levels to labels (optional).}

\item{title}{Character string for the plot title. Defaults to "Missing data".}

\item{subtitle}{Character string for the plot subtitle. Defaults to NULL.}

\item{x_lab}{Character string for the x-axis label. Defaults to the name of \code{x_var}.}

\item{y_lab}{Character string for the y-axis label. Defaults to the name of \code{y_var}.}
}
\value{
A ggplot object, or NULL if no missing combinations found.
}
\description{
Creates a tile plot highlighting combinations of grouping variables
that are expected but missing from the data. Allows for faceting.
}
\examples{
data("toy_data")

# Plot missing data across age and period, stratified by education, for each sex
plot_missing_data (data        = toy_data,
                   x           = period,
                   y           = age,
                   stratify_by = education,
                   for_each    = sex)


}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
