% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_two_cov.R
\name{testcov2}
\alias{testcov2}
\title{Hypothesis test for association between covariate and cure indicator adjusted by a second covariate}
\usage{
testcov2(x, time, z, delta, P = 999, H = NULL)
}
\arguments{
\item{x}{Numeric vector. The primary covariate whose association with the latent cure indicator is tested.}

\item{time}{Numeric vector. Observed survival or censoring times.}

\item{z}{Numeric vector. Secondary covariate for adjustment.}

\item{delta}{Numeric vector. Censoring indicator (1 indicates event occurred, 0 indicates censored).}

\item{P}{Integer. Number of permutations used to compute the permutation p-value. Default is 999.}

\item{H}{Optional numeric. Bandwidth parameter (currently unused, reserved for future extensions).}
}
\value{
List with components:
\describe{
\item{statistic}{Numeric. The test statistic value.}
\item{p.value}{Numeric. The permutation p-value assessing the null hypothesis of no association between \code{x} and the latent cure indicator, adjusting for \code{z}.}
}
}
\description{
Performs a permutation-based test assessing the association between a primary covariate (\code{x}) and the cure indicator, while adjusting for a secondary covariate (\code{z}).
The test calculates the p-value via permutation using the partial martingale difference correlation.
}
\details{
In order to test if the cure rate depends on the covariate \eqn{\boldsymbol{X}} given it depends on the covariate \eqn{\boldsymbol{Z}}. The hypotheses are
\deqn{
  \mathcal{H}_0 : \mathbb{E}(\nu | \boldsymbol{X}) \equiv 1 - p(\boldsymbol{X}) \quad \text{a.s.}
  \quad \text{vs} \quad
  \mathcal{H}_1 : \mathbb{E}(\nu | \boldsymbol{X}) \not\equiv 1 - p(\boldsymbol{X}) \quad \text{a.s.}
}
The proxy of the cure rate under the null hypothesis \eqn{\mathcal{H}_0} is obtained by:
\deqn{
 \mathbb{I}(T > \tau) + (1-\delta)\mathbb{I}(T \leq \tau) \, \frac{1 - p(\boldsymbol{Z})}{1 - p(\boldsymbol{Z}) + p(\boldsymbol{Z})S_0(T|\boldsymbol{X,Z})}.
}

The statistic for testing the covariate hypothesis is based on partial martingale difference correlation and it is given by:

\deqn{
 \text{pMDC}_n(\hat{\nu}_{\boldsymbol{H}}|\boldsymbol{X,Z})^2.
}

The null distribution is approximated using a permutation test.
}
\references{
Park, T., Saho, X. & Yao, S. (2015). Partial martingale difference correlation.
\emph{Electronic Journal of Statistics}, 9, 1492–1517. \doi{10.1214/15-EJS1047}
}
\seealso{
\code{\link{pmdc}} for the partial martingale difference correlation, \code{\link{pmdd}} for the partial martingale difference divergence,
\code{\link{testcov}} for the test for one covariate.
}
