% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{plot.roc}
\alias{plot.roc}
\title{plot roc curve}
\usage{
\method{plot}{roc}(
  x,
  y,
  which = 1:3,
  orientation = c("horizontal", "vertical"),
  cutoffs.1 = NULL,
  cutoffs.2 = NULL,
  cutoffs.3 = NULL,
  xlab.3 = NULL,
  labels.3 = NULL,
  xlim.3 = NULL,
  ylim.3 = c(0, 10),
  pos.legend.2 = "right",
  pos.legend.3 = "topright",
  ...
)
}
\arguments{
\item{x}{object of class \code{roc}.}

\item{y}{argument for generic \code{plot} function, not used here.}

\item{which}{which plots to show (see Details).}

\item{orientation}{indicate whether the plots should be arranged horizontally
or vertically.}

\item{cutoffs.1}{cutoff value(s) to be shown in the first plot.}

\item{cutoffs.2}{cutoff value(s) to be shown in the second plot.}

\item{cutoffs.3}{cutoff value(s) to be shown in the third plot.}

\item{xlab.3}{lable for x axis in third plot.}

\item{labels.3}{legend labels for third plot.}

\item{xlim.3}{xlim for third plot.}

\item{ylim.3}{ylim for third plot.}

\item{pos.legend.2}{legend position for second plot.}

\item{pos.legend.3}{legend position for third plot.}

\item{...}{other arguments for generic \code{plot} function, none are used here.}
}
\value{
\code{plot.roc} provides three plots:
\itemize{
\item The first plot contains the ROC curve.
\item The second plot contains curves for the sensitivity and the specificity
for all threshold values.
\item The third plot contains density plots for the two classification groups.
}
}
\description{
Plot an ROC curve.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
a <- roc(QIDS$QIDS, QIDS$depression, c("Yes","No"), "Yes")
plot(a, ylim.3 = c(0,.2), xlab.3= "QIDS value", cutoffs.1 = 14.5,
     cutoffs.2 = 14.5, cutoffs.3 = 14.5)
}
\author{
Mathijs Deen
}
