% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecFunctions.R
\name{characterize_peak}
\alias{characterize_peak}
\title{characterize_peak}
\usage{
characterize_peak(spec, option = 1, bin.size = 1, min.mz = 1000, max.mz = 2200)
}
\arguments{
\item{spec}{A data frame that contains m/z values of peaks, normalized intensities of peaks, species names, and strain names. Either an output of \code{\link{simulate_poly_spectra}} or one elements of a list output from \code{\link{simulate_many_poly_spectra}}.}

\item{option}{An option on how to merge peaks. There are two options: 1) no merge, thus take the highest intensity peak in each bin after binning a spectrum by bin.size, or 2) take a sum of intensity within each bin after binning a spectrum by bin.size.}

\item{bin.size}{An integer. A bin size. (1 by default)}

\item{min.mz}{A real number. Minimum mass-to-charge ratio. (1000 by default)}

\item{max.mz}{A real number. Maximum mass-to-charge ratio. (2200 by default)}
}
\value{
A data frame that contains m/z values of peaks (mz), intensities of peaks (int), species names (species), and strain names (strain). Species and strain columns may contain more than one species/strain if an option 2 is chosen.
}
\description{
This function characterizes peaks by species/strain in a simulated spectrum after taking the highest peak or merging peaks in each bin.
}
\examples{
spectra.processed.A <- process_monospectra(
   file=system.file("extdata", "listA.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.processed.B <- process_monospectra(
   file=system.file("extdata", "listB.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.processed.C <- process_monospectra(
   file=system.file("extdata", "listC.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.mono.summary.A <- summarize_monospectra(
   processed.obj=spectra.processed.A,
   species='A', directory=tempdir())
spectra.mono.summary.B <- summarize_monospectra(
   processed.obj=spectra.processed.B,
   species='B', directory=tempdir())
spectra.mono.summary.C <- summarize_monospectra(
   processed.obj=spectra.processed.C,
   species='C', directory=tempdir())
mono.info=gather_summary(c(spectra.mono.summary.A, spectra.mono.summary.B, spectra.mono.summary.C))
mixture.ratio <- list()
mixture.ratio['A']=1
mixture.ratio['B']=0.5
mixture.ratio['C']=0
sim.template <- create_insilico_mixture_template(mono.info)
insilico.spectrum <- simulate_poly_spectra(sim.template, mixture.ratio)
merged.spectrum <- characterize_peak(insilico.spectrum, option=2) 
}
