colprop.mle <- function(x, distr = "beta", tol = 1e-07, maxiters = 100, parallel = FALSE ){
  if ( distr == "beta" ) {
    res <- Rfast2::colbeta.mle(x, tol = tol, maxiters = maxiters, parallel = parallel)
  } else if ( distr == "logitnorm" ) {
    res <- Rfast2::collogitnorm.mle(x)
  } else if ( distr == "unitweibull" ) {
    res <- Rfast2::colunitweibull.mle(x, tol = tol, maxiters = maxiters, parallel = parallel)
  } else if ( distr == "sp" ) {
    res <- Rfast2::colsp.mle(x)
  } else if ( distr == "ibeta" ) {
    res <- .colibeta.mle(x, tol = tol)
  } else if ( distr == "hsecant01" ) {
    res <- .colhsecant01.mle(x, tol = tol)
  } else if ( distr == "kumar" ) {
    res <- .colkumar.mle(x, tol = tol, maxiters = maxiters)
  } else if ( distr == "simplex" ) {
    res <- .colsimplex.mle(x, tol = tol)
  } else if ( distr == "zil" ) {
    res <- .colzil.mle(x)
  } else if ( distr == "cbern" ) {
    res <- .colcbern.mle(x, tol = tol)
  }

  res
}


.colibeta.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] ) {
    a <- Rfast::ibeta.mle(x[,i], tol = tol)
    res[i, 1] <- c( a[2][[ 1 ]]$param[[ 1 ]], a[2][[ 1 ]]$param[[ 2 ]], a[2][[ 1 ]]$loglik )
  }
  colnames(res) <- c("alpha", "beta", "loglik")
  res
}

.colhsecant01.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 2)
  for (i in 1:ncol(x)){
    a <- Rfast::hsecant01.mle(x[,i], tol = tol)
    res[i, ] <- c( a$theta, a$loglik )
  }
  colnames(res) <- c("theta", "loglik")
  res
}

.colkumar.mle <- function(x, tol = tol, maxiters = maxiters) {
  res <- matrix(NA, dim(x)[2], 3 )
  for ( i in 1:dim(x)[2] ) {
    a <- Rfast2::kumar.mle(x[,i], tol = tol, maxiters = maxiters)
    res[i,1] <- c( a$param[[ 1 ]], a$param[[ 2 ]], a$loglik )
  }
  colnames(res) <- c("shape", "scale", "loglik")
  res
}

.colsimplex.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 3 )
  for ( i in 1:dim(x)[2] ) {
    a <- Rfast2::simplex.mle(x[,i], tol = tol)
    res[i, ] <- c( a$param[[ 1 ]], a$param[[ 2 ]], a$loglik )
  }
  colnames(res) <- c("mean", "sigma", "loglik")
  res
}

.colzil.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] ) {
    a <- Rfast2::zil.mle(x[, i])
    res[i, ] <- c(a$param, a$loglik)
  }
  colnames(res) <- c("prop1", "mean", "unbiased variance", "loglik")
  res
}

.colcbern.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 2)
  for ( i in 1:dim(x)[2] ) {
    a <- Rfast2::cbern.mle(x[, i], tol = tol)
    res[i, ] <- c( a$lam, a$loglik )
  }
  colnames(res) <- c("lam", "loglik")
  res
}




