% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cv.MLGL}
\alias{plot.cv.MLGL}
\title{Plot the cross-validation obtained from \code{\link{cv.MLGL}} function}
\usage{
\method{plot}{cv.MLGL}(x, log.lambda = FALSE, ...)
}
\arguments{
\item{x}{\code{\link{cv.MLGL}} object}

\item{log.lambda}{If TRUE, use log(lambda) instead of lambda in abscissa}

\item{...}{Other parameters for plot function}
}
\description{
Plot the cross-validation obtained from \code{\link{cv.MLGL}} function
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply cv.MLGL method
res <- cv.MLGL(X, y)
# Plot the cv error curve
plot(res)

}
\seealso{
\link{cv.MLGL}
}
