% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CZIGPMM.R
\name{CZIGPMM}
\alias{CZIGPMM}
\title{MM algorithm based on the AD method for multivariate compound zero-inflated generalized poisson distribution}
\usage{
CZIGPMM(data, phi0, phi, la, th, Maxiter = 2000, convergence = 1e-06, ...)
}
\arguments{
\item{data}{Data.frame or Matrix that contains corresponding covariates.}

\item{phi0}{Probability value for the zero-inflated parameter for CZIGP model.}

\item{phi}{Probability value for the zero-inflated parameter for ZIGP model.}

\item{la}{The scale parameter for ZIGP model.}

\item{th}{The discrete parameter for ZIGP model.}

\item{Maxiter}{The maximum number of iterations is specified by default as 2000.}

\item{convergence}{Specify the convergence criterion, the default is 1e-6.}

\item{...}{Additional arguments}
}
\value{
An object of class \code{CZIGPMM} that contains the following fields: total amount of observations,
the number of iterations, convergence rate, the log likelihood value, estimated results for the unknown parameters,
the standard deviation of estimate for the unknown parameters, the likelihood-based 95\% confidence interval for the unknown parameters,
information criterion: AIC value and BIC value.
}
\description{
Let \eqn{Z_0 \sim Bernoulli(1- \phi_0)}, \eqn{\bf{x} = (X_1,\cdots, X_m)^T}, \eqn{X_i \sim ZIGP(\phi_i, \lambda_i, \theta_i)}, for \eqn{i = 1,\cdots,m} , and \eqn{(Z_0,X_1,\cdots, X_m)}
be mutually independent. A random vector \eqn{\bf{y}=(Y_1,\cdots, Y_m)^T} follows a multivariate compound zero-inflated generalized poisson distribution if

\deqn{ \bf{y} \overset{\rm{d}}= Z_{0}\bf{x}= \left\{ \begin{array}{ll}
\bf{0} & \text{with probability} \ \lambda_0 \\ \bf{x} & \text{with probability} \ 1-\lambda_0 \\ \end{array} \right. }

where \eqn{\lambda_0 \in [0,1)}, \eqn{\bf{\phi}=(\phi_1,\cdots, \phi_m)^{T}  \in [0, 1)^m}, \eqn{\bf{\lambda}=(\lambda_1,\cdots, \lambda_m)^{T} \in \mathbb{R}_{+}^{m} }, \eqn{\bf{\theta}=(\theta_1,\cdots, \theta_m)^{T} \in [0, 1)^m}.
The \code{CZIGPMM} function is used to calculate the multivariate compound ZIGP model.
}
\details{
The \code{CZIGPMM} function is used to calculate multivariate compound zero-inflated generalized poisson distribution model using MM algorithms
based on AD technology. \code{data} is provided by user by default, it can be a data frame or a matrix. In addition, unknown parameters require users to give appropriate initial values,
where \code{0<=phi0<1}, each \code{phi} should \code{0<=phi<1}, \code{th} should \code{0<=th<1}, and each \code{la} should be greater than 0.
}
\examples{
x1 <- c(0,35,23,34,8,19,0,0,0,0)
x2 <- c(38,15,0,25,34,0,0,0,0,0)
y <- cbind(x1, x2)
phi0 = 0.5; phi = rep(0.5,2); la = rep(1,2); th = rep(0.1,2)
CZIGPMM(y, phi0, phi, la, th)

}
\references{
Tian G.L., Huang X.F. and Xu, J.(2019). 'An assembly and decomposition approach for constructing separable minorizing functions in a class of MM algorithms.' \emph{Statistica Sinica} \strong{29}(2), 961-982.

Huang X.F., Tian G.L., Zhang, C. and Jiang, X.(2017). 'Type I multivariate zero-inflated generalized Poisson distribution with applications.' \emph{Statistics and its Interface} \strong{10}(2), 291-311.
}
