% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMINP_preprocess.R
\name{MMINP.preprocess}
\alias{MMINP.preprocess}
\title{Data Preprocessing function for MMINP}
\usage{
MMINP.preprocess(
  data,
  normalized = TRUE,
  prev = NA,
  abund = NA,
  logtransformed = TRUE,
  scaled = TRUE
)
}
\arguments{
\item{data}{A numeric matrix or data frame containing measurements of
metabolites or microbial features.}

\item{normalized}{Logical, whether to transform measurements into relative
abundance or not.}

\item{prev}{A numeric ranging from 0 to 1, the minimum prevalence of features
to be retained. If set to NA, means no need to filter prevalence.}

\item{abund}{A numeric greater than 0, the minimum abundance (mean) of
features to be retained. If set to NA, means no need to filter abundance.}

\item{logtransformed}{Logical, whether do log transformation or not.}

\item{scaled}{Logical, whether scale the columns of data or not.}
}
\value{
A preprocessed numeric matrix for analysis of MMINP.
}
\description{
Before doing MMINP analysis, abundances of both microbial features and
metabolites should be preprocessed.
Both measurements are expected to be transformed to relative abundance (i.e.
proportion) and be log-transformed.
To meet the need of O2-PLS method, data must be scaled.
}
\details{
The rows of data must be samples and columns of data must be metabolites or
microbial features.
The filtering process (\code{prev} and \code{abund}) is before log
transformation and scale transformation.
}
\examples{
data(train_metag)
d <- MMINP.preprocess(train_metag)
d <- MMINP.preprocess(train_metag, prev = 0.3, abund = 0.001)
d[1:5, 1:5]
}
