% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{reg_simulation3}
\alias{reg_simulation3}
\title{The Function for the Simulation Study with the Variable Selection and Survey Weights}
\usage{
reg_simulation3(
  N,
  ni_lambda,
  beta,
  beta_b,
  dsq,
  sigmasq,
  delta,
  nu,
  muz,
  rho,
  sigmasq_z,
  zeta0,
  zeta1
)
}
\arguments{
\item{N}{The number of subjects.}

\item{ni_lambda}{The mean of Poisson distribution.}

\item{beta}{The covariates' coefficients. A 10 by 1 vector.}

\item{beta_b}{The slope of PD response.}

\item{dsq}{A part of covariance parameter.}

\item{sigmasq}{A part of covariance parameter.}

\item{delta}{The skewness parameter.}

\item{nu}{The degree of freedom.}

\item{muz}{The location parameter of the latent/selection variable.}

\item{rho}{The correlation parameter of the latent/selection variable.}

\item{sigmasq_z}{The variance parameter of the latent/selection variable.}

\item{zeta0}{The intercept term inside the logistic function.}

\item{zeta1}{The slope term inside the logistic function.}
}
\value{
A simulated dataset with the response variable \verb{y}, the design matrix \verb{X} and the survey weight \verb{survey_weight}.
}
\description{
This simulation study is designed to show the effectiveness of the grouped horseshoe prior for the variable selection and the \verb{WFPBB()} function for adjusting survey weights.
}
\details{
More details of the design of this simulation study can be found in the vignette. Users can access the vignette by the command \verb{vignette(package = "MSIMST")}.
}
\examples{
set.seed(100)
output_data <- reg_simulation3(N = 1000,
                               ni_lambda= 8,
                               beta = c(rep(1,6),rep(0,4)),
                               beta_b = 1.5,
                               dsq = 0.1,
                               sigmasq = 0.5,
                               delta = 0.6,
                               nu = 5.89,
                               muz = 0,
                               rho = 36.0,
                               sigmasq_z = 0.6,
                               zeta0 = -1.8,
                               zeta1 = 0.1)
y <- output_data$y
X <- output_data$X
survey_weight <- output_data$survey_weight

}
