% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{plot.emMSmix}
\alias{plot.emMSmix}
\title{Plot the MLEs for the fitted mixture of Mallows models with Spearman distance}
\usage{
\method{plot}{emMSmix}(x, max_scale_w = 20, mar_lr = 0.4, mar_tb = 0.2, ...)
}
\arguments{
\item{x}{An object of class \code{"emMSmix"} returned by \code{\link{fitMSmix}}.}

\item{max_scale_w}{Positive scalar: maximum magnification of the dots in the bump plot, set proportional to the MLEs of the weights. Defaults to 20.}

\item{mar_lr}{Numeric: margin for the left and right side of the plot. Defaults to 0.4.}

\item{mar_tb}{Numeric: margin for the bottom and top side of the plot. Defaults to 0.2.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
A list of 2 labelled plots, namely: i) \code{bump_plot}: a bump plot comparing the component-specific consensus rankings of the fitted mixture of Mallows models with Spearman distance (the size of the dots of each consensus ranking is proportional to the weight of the corresponding component); and ii) \code{est_clust_prob}: a heatmap of the estimated component membership probabilities is returned when \code{n_clust > 1}, otherwise \code{NULL}.
}
\description{
\code{plot} method for class \code{"emMSmix"}.
}
\examples{
## Example 1. Fit and plot a 3-component mixture of Mallows models with Spearman distance
## to the Antifragility dataset.
r_antifrag <- ranks_antifragility[, 1:7]
set.seed(123)
mms_fit <- fitMSmix(rankings = r_antifrag, n_clust = 3, n_start = 10)
p_mms_fit <- plot(mms_fit)
p_mms_fit$bump_plot()
p_mms_fit$est_clust_prob()

}
\references{
Sjoberg D (2020). ggbump: Bump Chart and Sigmoid Curves. R package version 0.1.10. \url{https://CRAN.R-project.org/package=ggbump}.

Wickham H et al. (2019). Welcome to the tidyverse. \emph{Journal of Open Source Software}, \bold{4}(43), 1686, DOI: 10.21105/joss.01686.

Wickham H (2016). ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York. ISBN 978-3-319-24277-4, \url{https://ggplot2.tidyverse.org}.
}
\seealso{
\code{\link{fitMSmix}}, \code{\link{summary.emMSmix}}
}
