% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGen_rare_group.R
\name{DataGen_rare_group}
\alias{DataGen_rare_group}
\title{Function used to generate input data (used only for Simulations)
Generate SPPMIs, dummy matrices based on prior group structures, and code-code pairs for tuning and evaluation}
\usage{
DataGen_rare_group(
  seed = NULL,
  p,
  n1,
  n2,
  n.common,
  n.group,
  sigma.eps.1,
  sigma.eps.2,
  ratio.delta,
  network.k,
  rho.beta,
  rho.U0,
  rho.delta,
  sigma.rare,
  n.rare,
  group.size
)
}
\arguments{
\item{seed}{for reproducibility}

\item{p}{the length of an embedding}

\item{n1}{the number of codes in site 1}

\item{n2}{the number of codes in site 2}

\item{n.common}{common: the number of overlapping codes}

\item{n.group}{the number of groups}

\item{sigma.eps.1}{the sd of error in site 1}

\item{sigma.eps.2}{the sd of error in site 2}

\item{ratio.delta}{the proportion of codes in each site that have site-specific effects applied to them}

\item{network.k}{the number of distinct blocks within each site for which unique inter-code correlations are modeled}

\item{rho.beta}{AR parameter for the group effects covariance matrix}

\item{rho.U0}{AR parameter for the code effects covariance matrix}

\item{rho.delta}{AR parameter for the code-site effects covariance matrix}

\item{sigma.rare}{the sd of error for rare codes (usually larger than sigma.eps.1 and sigma.eps.2)}

\item{n.rare}{The number of rare codes}

\item{group.size}{the size of each group}
}
\value{
Returns input data, SPPMIs, dummy matrices based on prior group structures and code-code pairs for tuning and evaluation
}
\description{
Function used to generate input data (used only for Simulations)
Generate SPPMIs, dummy matrices based on prior group structures, and code-code pairs for tuning and evaluation
}
