% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_SurvRegModel.R
\name{SurvRegModel}
\alias{SurvRegModel}
\alias{SurvRegStepAICModel}
\title{Parametric Survival Model}
\usage{
SurvRegModel(
  dist = c("weibull", "exponential", "gaussian", "logistic", "lognormal",
    "logloglogistic"),
  scale = 0,
  parms = list(),
  ...
)

SurvRegStepAICModel(
  dist = c("weibull", "exponential", "gaussian", "logistic", "lognormal",
    "logloglogistic"),
  scale = 0,
  parms = list(),
  ...,
  direction = c("both", "backward", "forward"),
  scope = list(),
  k = 2,
  trace = FALSE,
  steps = 1000
)
}
\arguments{
\item{dist}{assumed distribution for y variable.}

\item{scale}{optional fixed value for the scale.}

\item{parms}{list of fixed parameters.}

\item{...}{arguments passed to \code{\link[survival]{survreg.control}}.}

\item{direction}{mode of stepwise search, can be one of \code{"both"}
(default), \code{"backward"}, or \code{"forward"}.}

\item{scope}{defines the range of models examined in the stepwise search.
This should be a list containing components \code{upper} and \code{lower},
both formulae.}

\item{k}{multiple of the number of degrees of freedom used for the penalty.
Only \code{k = 2} gives the genuine AIC; \code{k = .(log(nobs))} is
sometimes referred to as BIC or SBC.}

\item{trace}{if positive, information is printed during the running of
\code{stepAIC}. Larger values may give more information on the fitting
process.}

\item{steps}{maximum number of steps to be considered.}
}
\value{
\code{MLModel} class object.
}
\description{
Fits the accelerated failure time family of parametric survival models.
}
\details{
\describe{
  \item{Response types:}{\code{Surv}}
}

Default argument values and further model details can be found in the source
See Also links below.
}
\examples{
\donttest{
## Requires prior installation of suggested packages rms and Hmisc to run

library(survival)

fit(Surv(time, status) ~ ., data = veteran, model = SurvRegModel)
}

}
\seealso{
\code{\link[rms]{psm}}, \code{\link[survival]{survreg}},
\code{\link[survival]{survreg.control}}, \code{\link[MASS]{stepAIC}},
\code{\link{fit}}, \code{\link{resample}}

\code{\link[MASS]{stepAIC}}, \code{\link{fit}},
\code{\link{resample}}
}
