% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MazamaCoreUtils-package.R
\docType{package}
\name{MazamaCoreUtils-package}
\alias{MazamaCoreUtils}
\alias{MazamaCoreUtils-package}
\title{MazamaCoreUtils: Utility Functions for Production R Code}
\description{
A suite of utility functions providing functionality commonly needed for production level projects such as logging, error handling, cache management and date-time parsing. Functions for date-time parsing and formatting require that time zones be specified explicitly, avoiding a common source of error when working with environmental time series.

The MazamaCoreUtils package was created by MazamaScience to
regularize our work building R-based web services.

The main goal of this package is to create an internally standardized set of
functions that we can use in various systems that are being run
operationally. Areas of functionality supported by this package include:

\itemize{
\item{ python style logging }
\item{ simple error messaging }
\item{ cache management }
\item{ API key handling }
\item{ date parsing and formatting }
\item{ lat/lon validation and uniqueID creation }
\item{ source code linting }
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/MazamaScience/MazamaCoreUtils}
  \item Report bugs at \url{https://github.com/MazamaScience/MazamaCoreUtils/issues}
}

}
\author{
\strong{Maintainer}: Jonathan Callahan \email{jonathan.s.callahan@gmail.com}

Other contributors:
\itemize{
  \item Eli Grosman \email{eligrosman1@gmail.com} [contributor]
  \item Spencer Pease \email{spencerpease618@gmail.com} [contributor]
  \item Thomas Bergamaschi \email{tbergama@gmail.com} [contributor]
}

}
\keyword{internal}
