% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_log2FC.R
\name{plotly_scatter}
\alias{plotly_scatter}
\title{Plotly Log2FC Scatter Plot}
\usage{
plotly_scatter(
  metalyzer_se,
  signif_colors = c(`#5F5F5F` = 1, `#FEBF6E` = 0.1, `#EE5C42` = 0.05, `#8B1A1A` = 0.01),
  class_colors = metalyzer_colors()
)
}
\arguments{
\item{metalyzer_se}{A Metalyzer object}

\item{signif_colors}{signif_colors}

\item{class_colors}{A csv file containing class colors hexcodes}
}
\value{
plotly object
}
\description{
This function returns a list with an interactive 
scatterplot based on log2 fold change data and a comprehensive Legend.
}
\examples{

metalyzer_se <- MetAlyzer_dataset(file_path = example_mutation_data_xl())
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = "Metabolism Indicators"
)
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Mutant_Control = "Sample Description"
)
metalyzer_se <- calculate_log2FC(
  metalyzer_se,
  categorical = "Mutant_Control",
  impute_perc_of_min = 0.2,
  impute_NA = TRUE
)

p_scatter <- plotly_scatter(metalyzer_se)
}
