% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.net_compare.R
\name{c_net_ego}
\alias{c_net_ego}
\alias{c_net_neighbors}
\title{Extract ego-centric subnetwork with preserved class attributes}
\usage{
c_net_ego(graph, nodes, order = 1, mode = "all")
}
\arguments{
\item{graph}{An igraph object with potential "metanet" class}

\item{nodes}{Center node(s) for subnetwork extraction (vertex IDs or names)}

\item{order}{Integer specifying the order of neighbors to include}

\item{mode}{Character scalar, either "in", "out" or "all" for directed networks}
}
\value{
metanet
}
\description{
Wrapper around \code{igraph::make_ego_graph()} that ensures output retains
"metanet" and "igraph" class structure. Supports single or multiple center nodes.
}
\examples{
library(igraph)
c_net_plot(co_net)
c_net_plot(c_net_ego(co_net, "s__Kribbella_catacumbae"))
nodes <- c("s__Kribbella_catacumbae", "s__Verrucosispora_andamanensis")
c_net_plot(c_net_ego(co_net, nodes))
}
