% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{validate_structureIndices}
\alias{validate_structureIndices}
\title{Validate Structure Indices for Island and Non-Island Data}
\usage{
validate_structureIndices(data, index_islands, index_nonislands)
}
\arguments{
\item{data}{A nested list \code{data[[tip]][[structure]]}.
Assumes that the number of structures is consistent across tips and that
within each structure, all tips have the same number of sites.
The number of structures is inferred from \code{length(data[[1]])}.}

\item{index_islands}{An integer vector specifying indices that correspond to island structures.}

\item{index_nonislands}{An integer vector specifying indices that correspond to non-island structures.}
}
\value{
No return value. The function stops execution if invalid indices are detected.
}
\description{
This function checks whether the provided indices for islands and non-islands
are within the valid range of structures in the dataset. It also warns if
any indices are present in both \code{index_islands} and \code{index_nonislands}.
}
\details{
The funct@exportion performs the following checks:
\itemize{
\item Ensures that all indices in \code{index_islands} and \code{index_nonislands} are within
the range of available structures.
\item Throws an error if any index is out of bounds.
\item Issues a warning if the same index appears in both \code{index_islands} and \code{index_nonislands}.
}
}
