% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StandardizedUniqueness.R
\name{stdUnique}
\alias{stdUnique}
\title{Generate Standardized Uniqueness from MLFA Results}
\usage{
stdUnique(res_MLFA, C)
}
\arguments{
\item{res_MLFA}{a list containing the MLFA model parameters returned by the MLFA function.}

\item{C}{an integer giving the number of mixture components.}
}
\value{
No return value. This function generates a plot of the uniqueness of the factor analysis model for a given cluster \eqn{C} (variance that is 'unique' to the outcome variable and not explained by the common factors).
}
\description{
This function generates uniqueness plots (proportion of variance in the outcome variables in Y that is not explained by the factor analysis model) based on the estimated error variance.
}
\examples{
# Load the necessary datasets
data(simulated_MLFA)  # Load a simulated dataset based on the MLFA model
# Extract matrices from the list
# Extract matrix Y of outcomes of interest for the factor analysis model
Y <- simulated_MLFA$Y
# Extract matrix X of fixed effect covariates for describing the latent factors
X <- simulated_MLFA$X
# Extract matrix Z of random effect covariates for describing the latent factors
Z <- simulated_MLFA$Z
# Extract matrix id containing subject identifiers.
id <-simulated_MLFA$id
#' # Run the MLFA (Mixture of Longitudinal Factor Analyzers) function with:
# C: number of classes or clusters in our simulated data was set to 2.
# d: number of latent factors in our simulated data was set to 1.
# max_it: maximum number of iterations is set to 50 for a quick test.
# Estimation of the parameters of the MLFA model using the simulated data.
result_MLFA <- MLFA(C = 2, d = 2, X, Y, Z, id, max_it = 50, fixed_factor =  c(1,6))
# Generate the uniqueness plots for the first cluster
stdUnique(result_MLFA, C=1)

}
