% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.diff.R
\name{group.diff}
\alias{group.diff}
\title{Function to exclude individuals from a database}
\usage{
group.diff(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  remove.gen = NULL,
  remove.database = NULL,
  remove.cohorts = NULL
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{remove.gen}{Generations of individuals to remove from the database (same IDs!)}

\item{remove.database}{Groups of individuals to remove from the database (same IDs!)}

\item{remove.cohorts}{Cohorts of individuals to remove from the database (same IDs!)}
}
\value{
Database excluding removals
}
\description{
Function to exclude individuals from a database
}
\examples{
data(ex_pop)
database <- group.diff(ex_pop, gen=1, remove.database=cbind(1,1))
}
