% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{force_posiDiag}
\alias{force_posiDiag}
\title{Force diagonal elements of a triangular matrix to be positive}
\usage{
force_posiDiag(x)
}
\arguments{
\item{x}{A matrix, which must be either upper-triangular or lower-triangular.}
}
\value{
An upper or lower triangular matrix with positive diagonal entries such that the matrix is still a valid decomposition of the matrix the input \code{x} is a decomposition of.
}
\description{
This function ensures that the triangular matrix in a QR (or other) decomposition has positive values along its diagonal.
}
\examples{
data(ais)
res <- MoE_clust(ais[,3:7], G=3, modelNames="EEE")
sig <- res$parameters$variance
a   <- force_posiDiag(sig$cholSigma)
b   <- chol(sig$Sigma)
all.equal(a, b)                    #TRUE
all.equal(crossprod(a), sig$Sigma) #TRUE
all.equal(crossprod(b), sig$Sigma) #TRUE
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
