% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{NumOutputs}
\alias{NumOutputs}
\title{Constructs the model numerical outputs (model fit, IRFs, GIRFs, FEVDs, GFEVDs, and term premia decomposition)}
\usage{
NumOutputs(
  ModelType,
  ModelPara,
  InputsForOutputs,
  FactorLabels,
  Economies,
  Folder2save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{ModelPara}{A list containing the point estimates of the model parameters. For details, refer to the outputs from the \code{\link{Optimization}} function.}

\item{InputsForOutputs}{A list containing the necessary inputs for generating IRFs, GIRFs, FEVDs, GFEVDs and Term Premia.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{Folder2save}{Folder path where the outputs will be stored. Default option saves the outputs in a temporary directory.}

\item{verbose}{Logical flag controlling function messaging. Default is TRUE.}
}
\value{
An object of class 'ATSMNumOutputs' containing the following keys elements:
\enumerate{
\item Model parameter estimates
\item Model fit of bond yields
\item IRFs
\item FEVDs
\item GIRFs
\item GFEVDs
\item Bond yield decomposition
}
}
\description{
Constructs the model numerical outputs (model fit, IRFs, GIRFs, FEVDs, GFEVDs, and term premia decomposition)
}
\details{
Both IRFs and FEVDs are computed using the Cholesky decomposition method. The risk factors are ordered as follows: (i) global unspanned factors, and (ii) domestic unspanned and spanned factors for each country. The order of countries follows the sequence defined in the \code{Economies} vector.
}
\examples{
data("ParaSetEx")
data("InpForOutEx")
# Adjust inputs according to the loaded features
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar ="Eco_Act" , GlobalVar = "Gl_Eco_Act", Economy, ModelType)

NumOut <- NumOutputs(ModelType, ModelParaEx, InpForOutEx, FacLab, Economy,
                     Folder2save = NULL, verbose = FALSE)

}
\references{
Pesaran, H. Hashem, and Shin, Yongcheol. "Generalized impulse response analysis in linear multivariate models." Economics letters 58.1 (1998): 17-29.
}
