% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNM_class_methods.R
\name{AIC,MNM-method}
\alias{AIC,MNM-method}
\title{AIC Method for "MNM" Class}
\usage{
\S4method{AIC}{MNM}(object)
}
\arguments{
\item{object}{An object of class \code{"MNM"}.}
}
\value{
A numeric value representing the AIC of the fitted model.
}
\description{
Computes the Akaike Information Criterion (AIC) for an object of class \code{"MNM"}.
AIC is a metric used for model comparison, balancing goodness of fit and model complexity.

The formula for AIC is:
\deqn{AIC = -2 \cdot \log L + 2 \cdot k}
where:
\itemize{
\item \eqn{\log L} is the log-likelihood of the model.
\item \eqn{k} is the number of parameters in the model.
}
}
