% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{MargMomCum}
\alias{MargMomCum}
\title{Marginal moments and cumulants from T-vectors}
\usage{
MargMomCum(d, q)
}
\arguments{
\item{d}{dimension of a vector X}

\item{q}{power of the Kronecker product}
}
\value{
A vector of indexes
}
\description{
A vector of indexes to select the moments and cumulants of the single components
of the random vector X for which a T-vector of moments and cumulants is available
}
\examples{
## For a 3-variate skewness and kurtosis vectors estimated from data, extract
## the skewness and kurtosis estimates for each of the single components of the vector
alpha<-c(10,5,0)
omega<-diag(rep(1,3))
X<-rSkewNorm(200, omega, alpha)
EVSK<-SampleEVSK(X)
## Get the univariate skewness and kurtosis for X1,X2,X3
EVSK$estSkew[MargMomCum(3,3)]
EVSK$estKurt[MargMomCum(3,4)]
}
\seealso{
Other Matrices and commutators: 
\code{\link{EliminIndx}()},
\code{\link{EliminMatr}()},
\code{\link{QplicIndx}()},
\code{\link{QplicMatr}()},
\code{\link{SymIndx}()},
\code{\link{SymMatr}()}
}
\concept{Matrices and commutators}
