% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{MomCumMVt}
\alias{MomCumMVt}
\title{Moments and cumulants Multivariate t-Student distribution}
\usage{
MomCumMVt(p, d, r, nCum = FALSE)
}
\arguments{
\item{p}{degrees of freedom}

\item{d}{dimension}

\item{r}{highest order of moments and cumulants}

\item{nCum}{if it is TRUE then cumulants are calculated}
}
\value{
The list of moments (or cumulants) in vector form
}
\description{
The t- distribution is defined as
\deqn{\mathbf{X} = \sqrt{\frac{p}{S^2}} \mathbf{Z}}
where \eqn{\mathbf{Z}} is a multivariate standard-normal random vector
and  \eqn{S^2} is a \eqn{\chi^2_p}.
random variable independent of \eqn{\mathbf{Z}}.
}
\examples{
# The first four moments for trivariate t with 10 d.f.
MomCumMVt(p=10,d=3,r=4,nCum=FALSE)

}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 Proposition XXXXXX
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
