% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{MomCumUniS}
\alias{MomCumUniS}
\title{Moments and cumulants Uniform Distribution on the Sphere}
\usage{
MomCumUniS(r, d, nCum = FALSE)
}
\arguments{
\item{r}{highest order of moments and cumulants}

\item{d}{dimension}

\item{nCum}{if it is TRUE then cumulants are calculated}
}
\value{
The list of moments and cumulants in vector form
}
\description{
By default, only moments are provided
}
\examples{
# The first four moments for d=3
MomCumUniS(4,3,nCum=0)
# The first four moments and cumulants for d=3
MomCumUniS(4,3,nCum=4)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 Proposition 5.3 p.297
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
