% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotest.R
\name{Isotest}
\alias{Isotest}
\title{Calculate the test statistics and p-values for testing monotonic trend}
\usage{
Isotest(data.nm, data.control, id, nano, response, dose, end, end.cat,
  unit, unit.cat, stat=c("E2","Williams","Marcus","M","ModM"), niter,
  method=p.adjust.methods, control.opt=c("same","all"), set.seed, vars)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{response}{Response (endpoint value)}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{stat}{Test statistics ("\code{E2}" for the global likelihood test,
"\code{Williams}" for Williams test, "\code{Marcus}" for Marcus test,
"\code{M}" for M test or "\code{ModM}" for modified M test)}

\item{niter}{Number of permutations}

\item{method}{Method used to adjust for the multiplicity (see \code{p.adjust.methods})}

\item{control.opt}{Option for the control doses if \code{unit} and
\code{unit.cat} are specified. If only control doses with the same unit of
measurement as the non-control ones are included, then specify
"\code{same}" in the \code{control.opt}. If all control doses with any
units of measurement are included, then specify "\code{all}".}

\item{set.seed}{Specify seed}

\item{vars}{Variable(s) used to subset the data}
}
\value{
This function calculates the value for the test statistics, the
  p-value (and its plot) based on the permutation, the adjusted p-value and
  the more likely direction of the monotonic trend.
}
\description{
This function provides the value of the test statistics, p-values, plot of
the null distribution and the observed test statistics, and adjusted p-values
according to the method chosen.
}
\details{
\itemize{
\item{This function performs trend testing for each nanomaterial in the
dataset (or for each subset of data). The different types of nanomaterials
are identified by their names. Therefore, if some control values are named
differently (see: \code{\link{geninvitro}} dataset and the \code{Examples}),
a separate dataset containing only these values first needs to be created.
Controls in the new dataset can be linked to the non-control observations
belonging to the same experiment through the identifier of the experiment
(the linking is performed inside this function). In this situation, it is
necessary to have an indicator that can identify different experiments (such
as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{If doses used in the experiment are all measured in the same unit of
measurement, then specify "\code{same}" in \code{control.opt}}.
\item{Trend testing can also be performed for subsets of data in each
nanomaterial, by specifying the variables used to split the data in
\code{vars}}.
}
}
\examples{
# Example 1:
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)
#
# Perform test for the monotonic trend in geninvitro, with DNA STRAND BREAKS
# as the endpoint, concentrations measured in "ug/cm2" and control doses
# measured in any units of measurement:
#
\donttest{Isotest(data.nm=invitrodata, data.control=controldata, id="experimentID",
        nano="name", response="value", dose="concentration", end="endpoint",
        end.cat="DNA STRAND BREAKS", unit="concentration_unit", unit.cat="ug/cm2",
        stat="E2", niter=1000, method="BH", control.opt="all", set.seed=1234)}

#' # Example 2:
# Split geninvitro according to the endpoint and unit of the concentration
# and then perform test for the monotonic trend for each subset of data:
#
\donttest{Isotest(data.nm=invitrodata, data.control=controldata,
        id="experimentID", nano="name", dose="concentration",
        response="value", stat="E2", niter=1000, method="BH", set.seed=1234,
        vars=c("endpoint","concentration_unit"))}
}
\references{
Lin D., Pramana, S., Verbeke, T., and Shkedy, Z. (2015). IsoGene:
  Order-Restricted Inference for Microarray Experiments. R package version
  1.0-24. \url{https://CRAN.R-project.org/package=IsoGene}

  Lin D., Shkedy Z., Yekutieli D., Amaratunga D., and Bijnens, L. (editors).
  (2012) Modeling Doseresponse Microarray Data in Early Drug Development
  Experiments Using R. Springer.
}
