% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frtab.R
\name{Frtab}
\alias{Frtab}
\title{Generate the number of unique values, the list of unique values, or the number
of observations of specified variable(s)}
\usage{
Frtab(data, x, cat, val, opt=c("un", "list", "obs", "ls.obs"),
  na.rm=FALSE)
}
\arguments{
\item{data}{Dataset}

\item{x}{Variable(s) to be explored}

\item{cat}{Variable used to group or subset the data}

\item{val}{Specific value of variable \code{cat}. If \code{val} is specified,
then only result for this value will be shown.}

\item{opt}{Options for the result: If \code{opt} is \code{un}, then the
number of unique values of \code{x} will be counted. If \code{opt} is
\code{list}, then the list of unique values of \code{x} will be
generated. If \code{opt} is \code{obs}, then the number of observations of
\code{x} will be counted. If \code{opt} is \code{ls.obs}, then the number
of observations for each unique value will be generated.}

\item{na.rm}{If \code{na.rm} is \code{FALSE} (the default), then missing
values are not removed from the dataset. If \code{na.rm}=\code{TRUE}, then
missing values are removed from the dataset}
}
\value{
This function generates the number of unique values, the list of
  unique values, or the number of observations of specified variable(s).
}
\description{
This function produces the number of unique values, the list of unique
values, or the number of observations of certain variable(s) in the dataset
}
\examples{

# List of nanomaterial in geninvitro dataset:
Frtab(data=geninvitro, x="name", opt="list")

# How many types of endpoint are measured in geninvitro data?
Frtab(data=geninvitro, x="endpoint", opt="un")

# How many observations are available for variable "unit"?
Frtab(data=geninvitro, x="unit", opt="obs")

# How many types of endpoint and nanomaterial are available in geninvitro data?
Frtab(data=geninvitro, x=c("name","endpoint"), opt="un")

# How many types of endpoint are available for each nanomaterial
# in geninvitro data?
Frtab(data=geninvitro, x="endpoint", cat="name", opt="un")

# How many observations are available for each endpoint in each nanomaterial?
Frtab(data=geninvitro, x=c("name","endpoint"), opt="ls.obs")

# How many observations with "DNA STRAND BREAKS" as the endpoint are available
# for each nanomaterial in geninvitro data?
Frtab(data=geninvitro, x="name", cat="endpoint", val="DNA STRAND BREAKS",
opt="ls.obs")


}
