% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoPlot.nm.R
\name{IsoPlot.nm}
\alias{IsoPlot.nm}
\title{Create a plot of the observations, sample means and fitted isotonic
regression curve for one nanomaterial}
\usage{
IsoPlot.nm(data.nm, dose, response, type = c("continuous", "ordinal"),
  add.curve = TRUE, nano.cat = NULL, xlabel="Dose", ylabel="Response")
}
\arguments{
\item{data.nm}{Dataset of a particular nanomaterial}

\item{dose}{Dose or concentration (with the same unit of measurement)}

\item{response}{Response (a certain endpoint value)}

\item{type}{Type of the dose}

\item{add.curve}{Adding curve to the plot}

\item{nano.cat}{Title of the plot (referring to the name of the nanomaterial)}

\item{xlabel}{label for the x-axis of the plot}

\item{ylabel}{label for the y-axis of the plot}
}
\value{
This function produces a plot of the observations, sample means and
  fitted isotonic regression curve for one nanomaterial
}
\description{
This function generates a dose-response plot (scatter plot) of the
observations, sample means and fitted isotonic regression curve for one
nanomaterial
}
\details{
This function is intended to be used inside the function
  \code{\link{Isoplot}}. However, it can also be used to generate a plot
  for one nanomaterial, with a particular unit of measurement of the dose and
  for a certain toxicity endpoint.
}
\examples{
#nm400 contains the result of genetic toxicity in vitro study of NM-400
#(Multi-walled carbon nanotubes) with associated controls
IsoPlot.nm(data.nm=nm400, dose="concentration", response="value",
           nano.cat="Multi-walled carbon nanotubes", xlabel="Concentration",
           ylabel="DNA STRAND BREAKS")
}
\references{
Lin D., Pramana, S., Verbeke, T., and Shkedy, Z. (2015). IsoGene:
  Order-Restricted Inference for Microarray Experiments. R package version
  1.0-24. \url{https://CRAN.R-project.org/package=IsoGene}

  Lin D., Shkedy Z., Yekutieli D., Amaratunga D., and Bijnens, L. (editors).
  (2012) Modeling Doseresponse Microarray Data in Early Drug Development
  Experiments Using R. Springer.
}
