% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniquePresent.R
\name{uniquePresent}
\alias{uniquePresent}
\title{Extract unique non-missing value from vector}
\usage{
uniquePresent(x, req.n1 = TRUE, na.pattern)
}
\arguments{
\item{x}{A vector, either numeric or character.}

\item{req.n1}{Require one unique value? If `TRUE` (default), an
error is thrown if non-unique values found. If `FALSE`, all
the unique values are returned.}

\item{na.pattern}{In addition to NA-elements, what text strings
should be considered missing? Default is empty strings and
strings only containing white spaces (`na.pattern="^ *$"`).}
}
\value{
a vector of same class as `x`
}
\description{
Extract unique non-missing value from vector
}
\details{
This function is particularly useful when combining data
    sets of which only some contain certain
    variables. \code{uniquePresent} with `req.n1=TRUE` makes sure the
    result is a single unique value (e.g., within subjects). A
    typical use is carrying subject-level covariates from one data
    set to another in a longitudinal analysis.
}
