% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandselect.R
\name{bandselect}
\alias{bandselect}
\title{Bandwidth selection function for 'npcox' and 'spcox'.}
\usage{
bandselect(cva, delta, obstime, bandwidth = FALSE)
}
\arguments{
\item{cva}{Covariate Z in h(t) = h0(t)exp(b(t)'Z)}

\item{delta}{Right censoring indicator for the model}

\item{obstime}{The observed time = min(censoring time, observed failure time)}

\item{bandwidth}{Bandwidth for kernel function, which can be specified. The default value is FALSE and can be selected through least prediction error over all subjects.}
}
\value{
Prediction error on given bandwidth or list that contains the optimal bandwidth, an arithmetic progression of bandwidths with corresponding prediction error.
}
\description{
The embeded bandwidth selection function in 'npcox' and 'spcox' together with prediction error calculation.
}
\details{
This is some description of this function.

'bandwidth_selection' function can provide the prediction error calculation with given bandwidth, or produce the optimal bandwidth based on an arithmetic progression of bandwidths.
}
\examples{
data(pbc)
dta  = na.omit(pbc[,c('time', 'status', 'age', "edema")])
dta  = dta[dta$time>600 & dta$time<2000,]
dta[,'status'] = sign(dta[,'status'])
colnames(dta) = c('time', 'status', 'age',  "edema")
res = bandselect(cva = dta[,3:4], delta = dta$status, obstime = dta$time, bandwidth = 700)
}
