% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcox.R
\name{spcox}
\alias{spcox}
\title{Nonparametric and semiparametric Cox regression model.}
\usage{
spcox(
  cva_cons,
  cva_time,
  delta,
  obstime,
  SE = FALSE,
  bandwidth = FALSE,
  resamp = 100
)
}
\arguments{
\item{cva_cons}{Covariate Z1 with constant coefficeint c in h(t) = h0(t)exp(c'Z1 + b(t)'Z2)}

\item{cva_time}{Covariate Z2 with time-varying coefficeint b(t) in h(t) = h0(t)exp(c'Z1 + b(t)'Z2)}

\item{delta}{Right censoring indicator for the model}

\item{obstime}{The observed time = min(censoring time, observed failure time)}

\item{SE}{Whether or not the estimation of standard error through resampling method will be done. The default value is FALSE.}

\item{bandwidth}{Bandwidth for kernel function, which can be specified. The default value is FALSE and can be selected through least prediction error over all subjects.}

\item{resamp}{Number of resampling for estimation of pointwise standard error. The default value is 100.}
}
\value{
a list that contain the estimation result of both temporal and constant coefficients, standard error estimation, selected or predesigned bandwidth, dataset, unconverged time points.
}
\description{
Estimation of proportional hazards (PH) model with time-varying coefficients and constant coefficients. Users should anticipate a significant increase in estimation time when using the `SE = TRUE` option. Both the number of covariates and the sample size can lead to estimation time increasing quadratically.
}
\details{
This is some description of this function.

'spcox' is designed for PH model with both time-varying and constant coefficients, h(t) = h0(t)exp(b(t)'Z1 + c*Z2), providing estimation of b(t), c and their standard errors.
}
\examples{
data(pbc)
pbc = pbc[(pbc$time < 3000) & (pbc$time > 800), ]
Z1  = as.matrix(pbc[,5])
Z2  = as.matrix(pbc[,c('albumin')])
colnames(Z1) = c('age')
colnames(Z2) = c('albumin')
del = sign(pbc$status)
tim = pbc$time
res1 = spcox(cva_cons = Z1, cva_time = Z2, delta = del, obstime = tim, bandwidth = 500)
}
