# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Perform inverse regex search (C++)
#'
#' This function takes character vector \code{patterns} with regex patterns
#' (or fixed strings),
#' and searches for match in the \code{x} string. It is inverse in the meaning,
#' that in \link[base]{grepl} single pattern is used against multiple strings;
#' instead, this function takes multiple patterns to fit on a single string.
#'
#' @param patterns a character vector of regex or fixed patterns.
#' @param x a string to search for the match.
#' @param fixed a logical, indicating whether patterns are fixed strings.
#' @return Logical vector of length as \code{patterns} with true if pattern
#' was found.
#' @examples
#' igrepl(c("today","b.* fox", "jumps over", "vigorous"),
#' "The quick brown fox jumps over the lazy dog", FALSE)
#' igrepl(c("today","brown fox", "jumps over", "vigorous"),
#' "The quick brown fox jumps over the lazy dog", TRUE)
#' @export
igrepl <- function(patterns, x, fixed = FALSE) {
    .Call(`_NUSS_igrepl`, patterns, x, fixed)
}

internal_unigram_sequence_segmentation <- function(sequences, to_search, to_replace, ids, points, omit_zero) {
    .Call(`_NUSS_internal_unigram_sequence_segmentation`, sequences, to_search, to_replace, ids, points, omit_zero)
}

