% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpm.R
\name{cpm}
\alias{cpm}
\alias{cpmIV}
\alias{cpmEV}
\alias{cpmFP}
\alias{cpmFPperm}
\alias{cpmIVperm}
\alias{cpmPlot}
\title{Connectome-based Predictive Modeling}
\usage{
cpmIV(neuralarray, bstat, kfolds, covar, thresh = .01,
      connections = c("separate", "overall"), groups = NULL,
      method = c("mean", "sum"), model = c("linear","quadratic","cubic"),
      corr = c("pearson","spearman"), nEdges,
      standardize = FALSE, cores, progBar = TRUE, plots = TRUE)

cpmIVperm(iter = 1000, ...)

cpmEV(train_na, train_b, valid_na, valid_b, thresh = .01,
      overlap = FALSE, progBar = TRUE)

cpmFP(session1, session2, progBar = TRUE)

cpmFPperm(session1, session2, iter = 1000, progBar = TRUE)

cpmPlot(cpm.obj, visual.nets = FALSE)
}
\arguments{
\item{neuralarray}{Array from \code{\link[NetworkToolbox]{convertConnBrainMat}} function}

\item{bstat}{Behavioral statistic for each participant with neural data (a vector)}

\item{kfolds}{Numeric.
Number of \emph{k}-fold validation samples.
Defaults to the number of participants in the sample (i.e., \emph{n}),
which is also known as leave-one-out validation.
Recommended folds are \code{5} and \code{10}}

\item{covar}{Covariates to be included in predicting relevant edges (\strong{time consuming}).
\strong{Must} be input as a \code{list()} (see examples)}

\item{thresh}{Sets an \eqn{\alpha} threshold for edge weights to be retained.
Defaults to \code{.01}}

\item{connections}{Character.
Should positive and negative correlations be separated or used together?
Defaults to \code{"separate"}}

\item{groups}{Allows grouping variables to be used for plotting points.
\strong{Must} be a vector.
Defaults to \code{NULL}}

\item{method}{Use \code{"mean"} or \code{"sum"} of edge strengths in the positive and negative connectomes.
Defaults to \code{"mean"}}

\item{model}{Regression model to use for fitting the data.
Defaults to \code{"linear"}}

\item{corr}{Correlation method for assessing the relationship between the behavioral measure and edges between ROIs.
Defaults to \code{"pearson"}.
Set to \code{"spearman"} for non-linear or monotonic associations}

\item{nEdges}{Number of participants that are required
to have an edge to appear in the plots.
Defaults to 10 percent of edges in participants}

\item{standardize}{Should the behavioral statistic (\code{bstat}) be standardized?
Defaults to \code{FALSE}}

\item{cores}{Number of computer processing cores to use when performing covariate analyses.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maximum amount of cores on your computer}

\item{progBar}{Should progress bar be displayed?
Defaults to \code{TRUE}.
Set to \code{FALSE} for no progress bar}

\item{plots}{Should plots be plotted?
Defaults to \code{TRUE}.
Set to \code{FALSE} to hide plots}

\item{train_na}{Training dataset
(an array from \code{\link[NetworkToolbox]{convertConnBrainMat}} function)}

\item{train_b}{Behavioral statistic for each participant for the \strong{training} neural data (a vector)}

\item{valid_na}{Validation dataset
(an array from \code{\link[NetworkToolbox]{convertConnBrainMat}} function)}

\item{valid_b}{Behavioral statistic for each participant for the \strong{validation} neural data (a vector)}

\item{overlap}{Should leave-one-out cross-validation be used?
Defaults to \code{FALSE} (use full dataset, no leave-one-out).
Set to \code{TRUE} to select edges that appear in every leave-one-out cross-validation network (\emph{time consuming})}

\item{session1}{Array from \code{\link[NetworkToolbox]{convertConnBrainMat}} function
(first session)}

\item{session2}{Array from \code{\link[NetworkToolbox]{convertConnBrainMat}} function
(second session)}

\item{iter}{Number of iterations to perform.
Defaults to \code{1000}}

\item{cpm.obj}{\code{\link[NetworkToolbox]{cpm}} object}

\item{visual.nets}{Boolean.
Uses \code{\link[qgraph]{qgraph}} to plot connectivity
between the networks as a network.
Defaults to \code{FALSE}.
Set to \code{TRUE} to visualize the networks}

\item{...}{Additional arguments to be passed from a \code{cpm} function}
}
\value{
\code{cpmIV} and \code{cpmEV}:

Returns a list containing:

\item{results}{A matrix containing: r coefficient (\code{r}), p-value (\code{p-value}),
mean absolute error (\code{mae}), root mean square error (\code{rmse})}

\item{posMask}{Positive connectivity for input in
\href{https://bioimagesuiteweb.github.io/webapp/connviewer.html}{BioImage Suite Connectivity Viewer}}

\item{negMask}{Negative connectivity for input in
\href{https://bioimagesuiteweb.github.io/webapp/connviewer.html}{BioImage Suite Connectivity Viewer}}

\code{cpmIVperm}:

Returns a matrix containing \emph{p}-values for positive and negative prediction models

\code{cpmFP}:

Returns a matrix containing the percentage
and number of correctly identified subjects for sessions 1 and 2

\code{cpmPlot}:

Returns plot of connectivity differences between the
positive and negative masks
}
\description{
Suite of functions for Connectome-based Predictive Modeling (CPM).
\strong{See and cite Finn et al., 2015; Rosenberg et al., 2016; Shen et al., 2017}

\itemize{

\item \code{cpmIV} --- Internal Validation method (Rosenberg et al., 2016; Shen et al., 2017). Using a leave-one-out approach,
this method correlates a behavioral statistic \code{bstat} with each edge of a whole-brain network across
participants. Using the significant edges in the network \code{thresh}, a connectome model
is built (without the participant's network). A linear regression model is fit, with the behavioral
statistic being regressed on the connectome model. The left out participants connectome model is then
used with the linear regression weights to compute their predicted behavioral score. This is repeated
for every participant. The predicted scores are correlated with their observed score. Significant values
suggest that the connectome is related to the behavioral statistic

\item \code{cpmIVperm} --- Performs a permutation test of the results obtained by \code{cpmIV}. The permutation test quantifies
whether the results obtained by the original \code{cpmIV} are significantly different than a random model
(see Shen et al., 2017)

\item \code{cpmEV} ---

UNDER DEVELOPMENT. External Validation method (Beaty et al., 2018). Performs similar function as \code{cpmIV} but uses data
to train \code{train_na} the connectome model using a behavioral statistic \code{train_b}.
This training connectome model is then used to predict another dataset \code{valid_na},
using the same behavioral statistic \code{valid_b}. The full training dataset \code{FALSE} or
the leave-one-out \code{overlap = TRUE} approach can be used

\item \code{cpmFP} --- Fingerprinting method (Finn et al., 2015). Uses CPM approach to identify participants across two sessions

\item \code{cpmFPperm} --- Fingerprinting method (Finn et al., 2015). Uses permutation method to estimate the significance of the \code{cpmFP} results

\item \code{cpmPlot} --- Plots the CPM results

}
}
\examples{
# Load data
behav <- behavOpen

\dontrun{

# Create path to temporary file
temp <- tempfile()

# Download to temporary file
googledrive::drive_download(
paste("https://drive.google.com/file/d/",
"1T7_mComB6HPxJxZZwwsLLSYHXsOuvOBt",
"/view?usp=sharing", sep = ""),
path = temp
)

# Load resting state brain data
load(temp)

# Run cpmIV
res <- cpmIV(neuralarray = restOpen, bstat = behav, cores = 4)

# Plot cpmIV results
cpmPlot(res)

}

}
\references{
Beaty, R. E., Kenett, Y. N., Christensen, A. P., Rosenberg, M. D., Benedek, M., Chen, Q.,
Fink, A., Qiu, J., Kwapil, T. R., Kane, M. J., & Silvia, P. J. (2018).
Robust prediction of individual creative ability from brain functional connectivity.
\emph{Proceedings of the National Academy of Sciences}, \emph{115}, 1087-1092.

Finn, E. S., Shen, X., Scheinost, D., Rosenberg, M. D., Huang, J., Chun, M. M., Papademetris, X., Constable, R. T. (2015).
Functional connectome fingerprinting: Identifying individuals using patterns of brain connectivity.
\emph{Nature Neuroscience}, \emph{18}, 1664-1671.

Rosenberg, M. D., Finn, E. S., Scheinost, D., Papademetris, X., Shen, X., Constable, R. T., Chun, M. M. (2016).
A neuromarker of sustained attention from whole-brain functional connectivity.
\emph{Nature Neuroscience}, \emph{19}, 165-171.

Shen, X. Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M., Papademetris, X., Constable, R. T. (2017).
Using connectome-based predictive modeling to predict individual behavior from brain connectivity.
\emph{Nature Protocols}, \emph{12}, 506-518.

Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
