% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spe.mantel.test.R
\name{spe.mantel.test}
\alias{spe.mantel.test}
\title{Mantel test between interspecific pairwise genetic distance and ecological
distance}
\usage{
spe.mantel.test(
  fas,
  dna.model = "raw",
  ecol.dist.method = "euclidean",
  mantel.method = "spearman",
  permutations = 999,
  en.vir = NULL
)
}
\arguments{
\item{fas}{DNAbin, reference dataset containing sample IDs, taxon information,
longitude and latitude, and barcode sequences of samples.}

\item{dna.model}{Character, specifying the evolutionary model to be used;
must be one of "raw" (default), "N", "TS", "TV", "JC69", "K80", "F81", "K81",
"F84", "BH87", "T92", "TN93", "GG95", "logdet", "paralin", "indel", or
"indelblock".}

\item{ecol.dist.method}{Character, distance measure to be used;
must be one of "euclidean" (default), "maximum", "manhattan", "canberra",
"binary" or "minkowski".}

\item{mantel.method}{Character, correlation method, as accepted by cor:
"pearson","spearman" (default) or "kendall".}

\item{permutations}{Numeric, the number of permutations required.}

\item{en.vir}{RasterBrick, the global bioclimate data output from
"raster::getData" function.}
}
\value{
The Mantel statistic.

The empirical significance level from permutations.

A matrix of interspecific pairwise genetic distance.

A matrix of interspecific pairwise ecological distance.
}
\description{
Determine the independence between genetic distance and
ecological distance for a reference dataset at the level of species.
}
\examples{
data(en.vir)
#envir<-raster::getData("worldclim",download=FALSE,var="bio",res=2.5)
#en.vir<-raster::brick(envir)

library(ape)
data(LappetMoths)
ref.seq<-LappetMoths$ref.seq

spe.mantel<-spe.mantel.test(fas=ref.seq,en.vir=en.vir)
spe.mantel$MantelStat.r
spe.mantel$p.value
}
\references{
Mantel N. 1967. The detection of disease clustering and a
generalized regression approach. Can. Res. 27:209-220.

Oksanen J., F.G. Blanchet, M. Friendly, R. Kindt, P. Legendre,
D. McGlinn, P.R. Minchin, R.B. O'Hara, G.L. Simpson, P. Solymos,
M.H.H. Stevens, E. Szoecs and H Wagner. 2016. vegan: Community Ecology
Package \url{https://CRAN.R-project.org/package=vegan}. r package version 2.5-6.
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{spe.mantel.test}
