% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen.R
\name{opsr_prepare_coefs}
\alias{opsr_prepare_coefs}
\title{Prepares Coefficients for Likelihood Function}
\usage{
opsr_prepare_coefs(theta, nReg)
}
\arguments{
\item{theta}{named coefficient vector as parsed from formula interface \code{\link{opsr}}.}

\item{nReg}{integer number of regimes.}
}
\value{
Named list of length \code{nReg}
}
\description{
Extracts the coefficients for each regime
}
\examples{
sim_dat <- opsr_simulate()
dat <- sim_dat$data
model <- ys | yo ~ xs1 + xs2 | xo1 + xo2
start <- opsr(model, dat, .get2step = TRUE)
opsr_prepare_coefs(start, 3)
}
