% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_opsr.R
\name{summary.opsr}
\alias{summary.opsr}
\title{Summarizing OPSR Model Fits}
\usage{
\method{summary}{opsr}(object, rob = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{"opsr"}.}

\item{rob}{if \code{TRUE}, the \code{\link[sandwich:sandwich]{sandwich::sandwich}} covariance matrix extimator is used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{"summary.opsr"}.
In particular the elements \code{GOF}, \code{GOFcomponents} and \code{wald} require further
explanation:
\item{GOF}{Contains the conventional \emph{goodness of fit} indicators for the full
model. \code{LL2step} is the log-likelihood of the Heckman two-step solution (if
the default starting values were used). \code{LLfinal} is the log-likelihood at
final convergence and \code{AIC}, \code{BIC} the corresponding information critereon.}
\item{GOFcomponents}{Contains the \emph{goodness of fit}  for the model components.
\code{LLprobit} is the log-likelihood (LL) contribution of the ordered probit model.
\code{LLprobitEl} the LL of the "equally likely" and \code{LLprobitMs} the LL of the
"market share" model. With these three metrics the pseudo R2 is computed and
returned as \code{pseudoR2el} and \code{pseudoR2ms}. \code{R2} reports the usual coefficient
of determination (for the continuous outcomes jointly and for each regime
separately).}
\item{wald}{Contains the results of two \emph{Wald-tests} as conducted with help
of \code{\link[car:linearHypothesis]{car::linearHypothesis}}. The two H0 hypothesis are 1. All coefficients
of the explanatory variables are 0 and 2. The rho parameters (capturing error
correlation) are zero.}
}
\description{
Follows the convention that \code{\link{opsr}} does the bare minimum model fitting and
inference is performed in \code{summary}.
}
