% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdowns.R
\name{getResultsTests}
\alias{getResultsTests}
\title{Get the tests for the results of an installed OmicNavigator study}
\usage{
getResultsTests(study, modelID, libraries = NULL)
}
\arguments{
\item{study}{An OmicNavigator study. Only accepts name of installed study
package.}

\item{modelID}{The modelID selected by the user in the app}

\item{libraries}{Character vector of library directories to search for study
packages. If \code{NULL}, uses \code{.libPaths}.}
}
\value{
A named list. The names are the identifiers to be displayed in the
dropdown menu, and each list element is a single character vector with the
description to be used as a tooltip in the app. If no custom description
was provided by the user, the tooltip text is simply the identifier.
}
\description{
This is the API endpoint the app uses to populate the dropdown menu in the
Differential Analysis tab with the list of available tests for the selected
model and study.
}
\details{
The tests correspond to those used when adding the results with
\code{\link{addResults}}. Any optional tooltips correspond to the
descriptions added with \code{\link{addTests}}.
}
\seealso{
\code{\link{getResultsStudies}},
\code{\link{getResultsModels}},
\code{\link{addResults}},
\code{\link{addTests}}
}
