% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRecordCount.R
\name{plotRecordCount}
\alias{plotRecordCount}
\title{Create a ggplot of the records' count trend}
\usage{
plotRecordCount(result, facet = NULL, colour = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of
\code{summariseRecordCount()}).}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}
}
\value{
A plot visualisation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\donttest{
library(omock)
library(OmopSketch)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

summarisedResult <- summariseRecordCount(
  cdm = cdm,
  omopTableName = "condition_occurrence",
  ageGroup = list("<=20" = c(0, 20), ">20" = c(21, Inf)),
  sex = TRUE
)

plotRecordCount(
  result = summarisedResult,
  colour = "age_group",
  facet = sex ~ .
)

cdmDisconnect(cdm = cdm)
}

}
