% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{flipImage}
\alias{flipImage}
\title{flip image horizontally or vertically}
\usage{
flipImage(image, mode = "horizontal")
}
\arguments{
\item{image}{a matrix, data frame or 3-dimensional array where the third dimension is equal to 3}

\item{mode}{one of 'horizontal', 'vertical'}
}
\value{
a matrix or 3-dimensional array where the third dimension is equal to 3
}
\description{
flip an image row-wise (horizontally) or column-wise (vertically)
}
\details{
This function flips an image row-wise or column-wise
}
\examples{

path = system.file("tmp_images", "1.png", package = "OpenImageR")

im = readImage(path)

flp = flipImage(im, mode = 'vertical')

}
