% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance measures (between constructs or elements).}
\usage{
distance(
  x,
  along = 1,
  dmethod = "euclidean",
  p = 2,
  normalize = FALSE,
  trim = 20,
  index = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{along}{Whether to calculate distance for 1 = constructs (default)
or for 2= elements.}

\item{dmethod}{The distance measure to be used. This must be one of
"euclidean", "maximum", "manhattan", "canberra", "binary"
or "minkowski". Any unambiguous substring can be given.
For additional information on the different types type
\code{?dist}.}

\item{p}{The power of the Minkowski distance, in case \code{"minkowski"}
is used as argument for \code{dmethod}.}

\item{normalize}{Use normalized distances. The distances are divided by the
highest possible value given the rating scale fo the grid,
so all distances are in the interval \verb{[0,1]}.}

\item{trim}{The number of characters a construct or element is trimmed to (default is
\code{20}). If \code{NA} no trimming occurs. Trimming
simply saves space when displaying correlation of constructs
with long names.}

\item{index}{Whether to print the number of the construct or element
in front of the name (default is \code{TRUE}). This is useful to avoid
identical row names, which may cause an error.}

\item{...}{Additional parameters to be passed to function \code{dist}.
Type \code{dist} for further information.}
}
\value{
\code{matrix} object.
}
\description{
Various distance measures between elements or constructs are calculated.
}
\examples{

# between constructs
distance(bell2010, along = 1)
distance(bell2010, along = 1, normalize = TRUE)

# between elements
distance(bell2010, along = 2)

# several distance methods
distance(bell2010, dm = "man") # manhattan distance
distance(bell2010, dm = "mink", p = 3) # minkowski metric to the power of 3

# to save the results without printing to the console
d <- distance(bell2010, trim = 7)
d

# some more options when printing the distance matrix
print(d, digits = 5)
print(d, col.index = FALSE)
print(d, upper = FALSE)

# accessing entries from the matrix
d[1, 3]

}
