% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_2_mask_to_mosaic.R
\name{mask_to_mosaic}
\alias{mask_to_mosaic}
\title{Apply a Binary Raster Mask (and Optional Geographic Clip) to a Two-Band Mosaic}
\usage{
mask_to_mosaic(
  mosaic_path,
  mask_raster_path,
  output_path = NULL,
  valid_mask_value = 1,
  crs_target = 3035,
  shapefile_clip = NULL
)
}
\arguments{
\item{mosaic_path}{Character. Path to the input 2-band raster mosaic (e.g., with RBR and DOY).}

\item{mask_raster_path}{Character. Path to the binary mask raster (e.g., burnable areas).}

\item{output_path}{Character (optional). Output destination. There are three behaviors:
\itemize{
  \item If `NULL`, the output is saved in the same folder as the input mosaic, using the same
        base name with suffix `_mosaic_masked_res90m.tif`.
  \item If a directory path is provided, the output file will be saved inside that folder,
        using the same base name as the input mosaic, with suffix `_mosaic_masked_res90m.tif`.
  \item If a full file path ending in `.tif` is provided, that name is used directly as the output.
}}

\item{valid_mask_value}{Numeric. Value in the mask that defines valid pixels (default is 1).}

\item{crs_target}{Integer or character. EPSG code for reprojection (only used if needed). Default: 3035.}

\item{shapefile_clip}{Character (optional). Path to a shapefile to further crop and mask the mosaic.}
}
\value{
Character. Full path to the final masked (and optionally clipped) raster.
}
\description{
This function applies a binary raster mask to a 2-band burned area mosaic (RBR and DOY).
All pixels in the mosaic where the mask does not match `valid_mask_value` are assigned `NA`.
Optionally, a shapefile can be provided to crop and mask the mosaic to a specific geographic area
(e.g., the Iberian Peninsula).

The function ensures that the mask raster is projected and aligned to the mosaic before applying.
The output is saved with the same resolution as the input mosaic.
}
\details{
This function is typically used after mosaicking burned area products derived from satellite imagery.
It filters areas outside a burnable mask (e.g., based on land cover) and optionally restricts output
to a defined geographic region (e.g., the Iberian Peninsula).

Input mosaic must have:
- Band 1: Relative Burn Ratio (RBR)
- Band 2: Day of Year (DOY)

Output raster is written in GeoTIFF format with LZW compression.
}
\note{
Examples require large external raster files (hosted on Zenodo).
Therefore, they are wrapped in dontrun{} to avoid errors during R CMD check
and to ensure portability.
}
\examples{
\dontrun{
# Case 1: Let the function generate the output name in the same folder
mask_to_mosaic(
  mosaic_path = "data/IBERIAN_MinMin_all_year_2012_mosaic_res90m.tif",
  mask_raster_path = "data/burneable_mask_corine_ETRS89.tif"
)

# Case 2: Save the output to a specific folder, name generated automatically
mask_to_mosaic(
  mosaic_path = "data/IBERIAN_MinMin_all_year_2012_mosaic_res90m.tif",
  mask_raster_path = "data/burneable_mask_corine_ETRS89.tif",
  output_path = "outputs/"
)

# Case 3: Define the full output file name explicitly
mask_to_mosaic(
  mosaic_path = "data/IBERIAN_MinMin_all_year_2012_mosaic_res90m.tif",
  mask_raster_path = "data/burneable_mask_corine_ETRS89.tif",
  output_path = "outputs/custom_masked_output_2012.tif"
)
}

}
