% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_1_mosaic_reproject_resample.R
\name{mosaic_reproject_resample}
\alias{mosaic_reproject_resample}
\title{Mosaic, Reproject, and Resample Burned Area Tiles}
\usage{
mosaic_reproject_resample(
  folder_path,
  mask_path,
  year = NULL,
  raster_pattern = "IBERIAN_MinMin_all_year_*.tif",
  crs_target = "EPSG:3035",
  res_target = 90,
  nodata_value = -9999
)
}
\arguments{
\item{folder_path}{Character. Path to the folder containing the raster tiles.}

\item{mask_path}{Character. Path to a polygon shapefile used to mask the rasters (e.g., burnable area mask).}

\item{year}{Integer or character. Year label used for naming output files. If NULL, uses folder name.}

\item{raster_pattern}{Character. Regex pattern to identify input raster tiles. Default: 'IBERIAN_MinMin_all_year_*.tif'.}

\item{crs_target}{Character. EPSG code string for the target CRS to reproject (default: "EPSG:3035").}

\item{res_target}{Numeric. Target spatial resolution in meters. Default: 90.}

\item{nodata_value}{Numeric. NoData value to assign to missing values. Default: -9999.}
}
\value{
Character. Full path to the final resampled GeoTIFF mosaic.
}
\description{
This function creates a seamless mosaic from multiple raster tiles (e.g., RBR and DOY composites),
masks them with a shapefile (e.g., Iberian Peninsula), reprojects the mosaic to a specified CRS
(default: EPSG:3035), and resamples it to a target resolution (default: 90m).

It assumes the input rasters are two-band GeoTIFFs:
- Band 1: RBR (Relative Burn Ratio)
- Band 2: DOY (Day of Year of fire)
}
\details{
The function uses `gdalbuildvrt` and `gdalwarp` for efficient VRT-based mosaicking and reprojection.
Steps:
1. Apply spatial mask to each raster tile.
2. Create VRT mosaic.
3. Reproject and resample the mosaic with `gdalwarp`.
4. Clean NoData values and assign band names ('rbr', 'doy').
5. Save compressed GeoTIFF output.
}
\note{
Examples require large external raster files (hosted on Zenodo)
and depend on external software (Python, GDAL). Therefore, they are wrapped
in dontrun{} to avoid errors during R CMD check and to ensure portability.
}
\examples{
\dontrun{
mosaic_reproject_resample(
  folder_path = "ZENODO/exdata",
  mask_path = "ZENODO/exdata/iberian_peninsula_proj_final.shp",
  year = 2012,
  raster_pattern = "IBERIAN_MinMin_all_year_2012_*.tif",
  crs_target = "EPSG:3035",
  res_target = 90
)
}

}
