% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.process_otsu_regenera.R
\name{process_otsu_regenera}
\alias{process_otsu_regenera}
\title{Detect Post-Fire Regeneration Using Otsu or Fixed Thresholds}
\arguments{
\item{rbr_post}{Path to post-fire RBR or dNBR raster. Alternatively, provide `nbr_pre_path` and `nbr_post_path`.
If a named list is provided, names should match the format `"P1"`, `"P2"`, etc.}

\item{nbr_pre_path}{Path to pre-fire NBR raster (for index computation).}

\item{nbr_post_path}{Path to post-fire NBR raster (for index computation).}

\item{rbr_date}{Optional path to an RBR raster used to mask previously burned areas (RBR \\ge 0).}

\item{output_dir}{Directory where outputs (rasters, shapefiles, plots) will be saved.}

\item{python_exe}{Path to the Python executable (used to call GDAL).}

\item{gdal_polygonize_script}{Path to `gdal_polygonize.py` script.}

\item{n_rows, n_cols}{Number of rows and columns for tiling. Ignored if `tile = FALSE`.}

\item{tile_overlap}{Overlap size (in meters) between tiles. Used for seamless polygonization.}

\item{tile}{Logical. If `TRUE`, raster is tiled before polygonization.}

\item{index_type}{Index type to compute: either `"RBR"` or `"dNBR"`. Ignored if `rbr_post` is provided.}

\item{trim_percentiles}{Data frame with columns `min` and `max`, defining percentile ranges
to clip negative RBR values before thresholding.
**Note:** This parameter is currently not used unless percentile-based thresholding is implemented.}

\item{bind_all}{Logical. If `TRUE`, all shapefiles from each threshold are merged into one combined shapefile.}

\item{regen_year}{Integer vector specifying the number of years after the fire to consider for regeneration (e.g., `c(2)`).}

\item{fire_year}{Integer indicating the fire year. Used for output naming and labeling.}

\item{use_fixed_threshold}{Logical. If `TRUE`, applies `fixed_threshold_value` instead of using the default threshold (< 0).}

\item{fixed_threshold_value}{Numeric threshold to use when `use_fixed_threshold = TRUE`. Default is `-100`.}

\item{output_format}{Character. Output format for saved files: `"shp"` for ESRI Shapefile (default) or `"geojson"` for GeoJSON.}
}
\value{
A named list of results per regeneration year (`P1`, `P2`, etc.) with:
\describe{
  \item{`raster`}{Path to the binary regeneration raster for that year.}
  \item{`shapefile`}{Path to the shapefile with polygons derived from the raster tiles for that year.}
}

If `bind_all = TRUE`, an additional item named `combined` is returned, which contains the path to a single shapefile:
\item{`combined`}{Path to the shapefile with all valid regeneration polygons combined across all years. The filename includes all `P` labels used (e.g., `_P1P2_`).}
}
\description{
This function detects vegetation regeneration signals using negative RBR or dNBR values.
By default (`use_fixed_threshold = FALSE`), the function identifies regeneration areas where
RBR or dNBR values are below 0. If `use_fixed_threshold = TRUE`, a fixed threshold value
(e.g., -100) is applied instead.

Optionally, percentile-based clipping can be applied before thresholding, and tiling
can be used to handle large rasters. The function outputs binary rasters and shapefiles,
optionally merged into a single shapefile if `bind_all = TRUE`.

If a historical burn raster (`rbr_date`) is provided, it will be used to mask out areas
previously burned (i.e., where RBR \\ge 0), so that regeneration is only detected in those
affected by the most recent fire.
}
\note{
Examples require large external raster files (hosted on Zenodo)
and depend on external software (Python, GDAL). Therefore, they are wrapped
in dontrun{} to avoid errors during R CMD check and to ensure portability.
}
\examples{
\dontrun{
# Regeneration detection using RBR raster and default threshold (< 0)
process_otsu_regenera(
  rbr_post = list(P2 = "data/RBR_1986.tif"),
  output_dir = "output/regenera",
  python_exe = "/usr/bin/python3",
  gdal_polygonize_script = "/usr/bin/gdal_polygonize.py",
  fire_year = 1984,
  regen_year = c(2),
  use_fixed_threshold = FALSE,
  output_format = c("geojson")
)

# Same detection but using a fixed threshold of -150
process_otsu_regenera(
  rbr_post = list(P2 = "data/RBR_1986.tif"),
  output_dir = "output/regenera",
  python_exe = "/usr/bin/python3",
  gdal_polygonize_script = "/usr/bin/gdal_polygonize.py",
  fire_year = 1984,
  regen_year = c(2),
  use_fixed_threshold = TRUE,
  fixed_threshold_value = -150,
  bind_all = FALSE,
  n_rows = 2,
  n_cols = 3,
  tile_overlap = 1000,
  tile = TRUE,
  output_format = c("shp")
)
}

}
