% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PBIR1.R
\name{PBIR1}
\alias{PBIR1}
\title{Estimate the PBIR curve over a time window}
\usage{
PBIR1(
  t2PROGRESSION,
  STATUS_PROGRESSION,
  t2RESPONSE,
  STATUS_RESPONSE,
  time = NULL,
  alpha = 0.95
)
}
\arguments{
\item{t2PROGRESSION}{time to progression/death or censoring}

\item{STATUS_PROGRESSION}{binary indicator for progression status: 1 for progression/death; 0 for censoring}

\item{t2RESPONSE}{time to response or censoring}

\item{STATUS_RESPONSE}{binary indicator for response status: 1 for response; 0 for censoring}

\item{time}{user-selected time points at which the PBIR is estimated; the default value is "NULL" and the PBIR will be estimated at all observed time points}

\item{alpha}{coverage level of the point-wise confidence interval for PBIR curve; the default value is 0.95}
}
\value{
a data matrix containing "time", "PBIR estimates", "standard errors of PBIR estimates",  "confidence intervals of the PBIR"
}
\description{
Estimate the PBIR curve over a time window
}
\examples{

library(survival)
n=100
set.seed(10)

# Generate the data

trt=rbinom(n, 1, 0.5)
error=rnorm(n)
tr=exp(rnorm(n)+error-trt*0.5+0.5)
tp=exp(rnorm(n)+error+trt*0.25)
tr[tp<tr]=Inf
tc=runif(n, 3, 8.5)
t2response=pmin(tr, tc)
delta_response=1*(tr<tc)
t2progression=pmin(tp, tc)
delta_progression=1*(tp<tc)

# Estimate the PBIR in two groups

fit1=PBIR1(t2PROGRESSION=t2progression[trt==1],
           STATUS_PROGRESSION=delta_progression[trt==1],
           t2RESPONSE=t2response[trt==1],
           STATUS_RESPONSE=delta_response[trt==1])

fit0=PBIR1(t2PROGRESSION=t2progression[trt==0],
           STATUS_PROGRESSION=delta_progression[trt==0],
           t2RESPONSE=t2response[trt==0],
           STATUS_RESPONSE=delta_response[trt==0])


# Plot the estimated PBIR by group

tt1=c(0, fit1$time)
PBIR1=c(0, fit1$PBIR)
B1=length(tt1)
tt1=rep(tt1, rep(2, B1))[-1]
PBIR1=rep(PBIR1, rep(2, B1))[-(2*B1)]
tt0=c(0, fit0$time)
PBIR0=c(0, fit0$PBIR)
B0=length(tt0)
tt0=rep(tt0, rep(2, B0))[-1]
PBIR0=rep(PBIR0, rep(2, B0))[-(2*B0)]
plot(range(c(fit1$time, fit0$time)), range(c(fit1$PBIR, fit0$PBIR)),
     xlab="time",  ylab="PBIR",
     main="black: group 0; red: group 1", type="n")
lines(tt0, PBIR0, col=1)
lines(tt1, PBIR1, col=2)
}
\references{
Huang, B., Tian, L., Talukder, E., Rothenberg, M., Kim, DY., and Wei, LJ. (2018) Evaluating Treatment Effect Based on Duration of Response for a Comparative Oncology Study. JAMA Oncol, doi: 10.1001/jamaoncol.2018.0275

Huang, B., Tian, L., McCaw, Z., Luo, Talukder, E., X., Rothenberg, M., Xie, W., Choueiri, T., Kim, DY., & Wei, LJ. (2020). Analysis of Response Data for Assessing Treatment Effects in Comparative Clinical Studies. Ann Intern Med, doi: 10.7326/M20-0104.
}
