% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Resolvable.R
\name{Resolvable}
\alias{Resolvable}
\title{Resolvable Balanced Incomplete Block Design RBIBD}
\usage{
Resolvable(n, mat)
}
\arguments{
\item{n}{The sub-variety of the block to be deleted.}

\item{mat}{The matrix of the BIB.}
}
\value{
A LIST of:
\enumerate{
 \item[\code{V}] Number of treatments in the RBIBD.
 \item[\code{B}] Number of blocks of the RBIBD.
 \item[\code{R}] Repetition of each treatment.
 \item[\code{K}] Size of each block.
 \item[\code{BIB}] The configuration of the RBIBD.
}
}
\description{
Extracts the Resolvable Balanced Incomplete Block Design (RBIBD) of
any BIBD constructed from a projective geometry.
}
\examples{
\dontrun{
m<-4
X<-BIB(m)   #BIBD from PG(4,2)

n<-1
mat<-X$BIB
Y<-Resolvable(n,mat) #Extracts the RBIBD


}
}
\references{
D. Dugué Traité de statistique théorique et appliquée, Masson et Cie, 1958.
}
\author{
Mohamed Laib, Abla Boudraa and Zebida Gheribi-Aoulmi
}
