% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_get_baf.R
\name{pl_get_baf}
\alias{pl_get_baf}
\title{Download 2020 Block Assignment Files for a State}
\usage{
pl_get_baf(abbr, geographies = NULL, cache_to = NULL, refresh = FALSE)
}
\arguments{
\item{abbr}{the state abbreviation to get the BAF for}

\item{geographies}{the geographies to get. Defaults to all available.}

\item{cache_to}{the file name, if any, to cache the results to (as an RDS).
If a file exists and \code{refresh=FALSE}, will read BAF from this file.}

\item{refresh}{if \code{TRUE}, force a re-download of the BAF data.}
}
\value{
A list of data frames, one for each available BAF geography.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
From the Census: "The Block Assignment Files (BAFs) are among the geographic
products that the Census Bureau provides to states and other data users
containing the small area census data necessary for legislative
redistricting.  The BAFs contain Census tabulation block codes and geographic
area codes for a specific geographic entity type."
}
\examples{
pl_get_baf("RI")
pl_get_baf("RI", "VTD")

}
\concept{advanced}
